package com.tandbergtv.cms.portal.content.client.title.view.sites;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

class TargetClickListener implements ClickHandler {

	SitesPanel parent;

	private ContentConstants displayConstants = (ContentConstants) GWT.create(ContentConstants.class);
	
	
	public TargetClickListener(SitesPanel parent) {
		this.parent = parent;
		
	}
	
	@Override
	public void onClick(ClickEvent event) {
		List<Integer> siteIds = new ArrayList<Integer>();
		if (parent.isSelectSites() == true) {
			siteIds = parent.getSelectedSiteIds();
			if (siteIds.size() == 0) {
				parent.reportFailure(parent.getTab().getViewMessages().selectAtLeastOneSiteMessage());
				return;
			}
		}
		
		getConfirmation(siteIds);
	}
	
	void getConfirmation(final List<Integer> siteIds) {
		final PopupContainer confirmation = new PopupContainer(false, true);
		VerticalContainer popContainer = new VerticalContainer();
		
		popContainer.add(new LabelWidget(parent.getTab().getViewMessages().targetConfirmationMessage()));
		HorizontalContainer buttonContainer = new HorizontalContainer();
		
		// yes button
		ButtonWidget yesButton = new ButtonWidget(displayConstants.confirmationYes());
		yesButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		yesButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				confirmation.hide();
				if (siteIds.size() > 0)
					parent.getTab().target(siteIds);
				else
					parent.getTab().targetWithRules();
			}
		});
		buttonContainer.add(yesButton);
		
		// no button
		ButtonWidget noButton = new ButtonWidget(displayConstants.confirmationNo());
		noButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		noButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				confirmation.hide();
			} });
		buttonContainer.add(noButton);
		
		popContainer.add(buttonContainer);
		popContainer.setCellHorizontalAlignment(buttonContainer, VerticalContainer.ALIGN_CENTER);
		confirmation.add(popContainer);
		confirmation.center();
		confirmation.show();
	}
	
}