/*
 * Created on Sep 13, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.thumbnail;

import com.google.gwt.user.client.Random;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;

/**
 * Widget for the Title Thumbnail
 * 
 * @author Vijay Silva
 */
public class TitleThumbnailWidget extends Composite {

	private ImageWidget imageWidget;
	private Long titleId;
	private Long assetId;

	/**
	 * Constructor
	 */
	public TitleThumbnailWidget() {
		imageWidget = new ImageWidget();
		initWidget(imageWidget);
		addStyleName("content-TitleThumbnailWidget");
	}

	/**
	 * Set the input URL for the widget
	 */
	public void setInput(Long titleId, Long assetId) {
		this.titleId = titleId;
		this.assetId = assetId;
		refresh();
	}

	/**
	 * Refresh the widget, updating the view based on the current input
	 */
	public void refresh() {
		String url = "cms_contentmgmt_ui/jsps/title_thumbnail.jsp?titleId=";
		if (titleId != null)
			url += titleId.toString();

		if (assetId != null) {
			url += "&assetId=" + assetId.toString();
		}

		url += "&key=" + Random.nextInt();
		imageWidget.setUrl(url);
	}

	/**
	 * @return the titleId
	 */
	public Long getTitleId() {
		return titleId;
	}

	/**
	 * @return the assetId
	 */
	public Long getAssetId() {
		return assetId;
	}
}
