package com.tandbergtv.cms.portal.content.client.title.view.videoplayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import pl.rmalinowski.gwt2swf.client.ui.SWFSettings;
import pl.rmalinowski.gwt2swf.client.ui.SWFWidget;
import pl.rmalinowski.gwt2swf.client.utils.PlayerVersion;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArrayString;

/**
 * Custom GWT widget that wraps around the JW flash media player
 * Extends SWFWidget which is a GWT wrapper for flash components. 
 * @author bng
 */ 
public class JWPlayerWidget extends SWFWidget{
    //Map to store player instance by id as there can be many player instances at the same time 
	protected static Map<String, JWPlayerWidget> players= new HashMap<String, JWPlayerWidget>(); 
	private String playerId; 
    private String curPosition;

	final public static String DEFAULT_SWF_FILE = "player-5.2.1151.swf"; 
	final public static String DEFAULT_MIN_FLASH_VERSION = "9,0,124"; 
	final public static int DEFAULT_WIDTH = 470; 
	final public static int DEFAULT_HEIGHT = 290; 
	
    final public static String VAR_SUPPORTED_FORMATS = "supportedformats";
    final public static String VAR_WIDTH = "width";
    final public static String VAR_HEIGHT = "height";
    final public static String VAR_SWFFILE = "swffile";
    final public static String VAR_MINFLASHVERSION = "minflashversion";
    final public static String FLASH_VAR_TYPE = "type";
    final public static String FLASH_VAR_STREAMER = "streamer";
    final public static String FLASH_VAR_FILE = "file";
    final public static String FLASH_VAR_AUTOSTART = "autostart";
    final public static String FLASH_VAR_STRETCHING = "stretching";
    final public static String FLASH_VAR_FRONT_COLOR = "frontcolor";
    final public static String FLASH_VAR_BACK_COLOR = "backcolor";
    final public static String FLASH_VAR_LIGHT_COLOR = "lightcolor";

    final public static String PARAM_VAR_ALLOWFULLSCREEN = "allowfullscreen";
    final public static String PARAM_VAR_ALLOWSCRIPTACCESS = "allowscriptaccess";
    final public static String PARAM_VAR_VMODE = "wmode";

    final public static String STATE_PAUSED = "PAUSED";
    final public static String STATE_PLAYING = "PLAYING";
    final public static String STATE_BUFFERING = "BUFFERING";
    final public static String STATE_IDLE = "IDLE";
    
    final static List<String>  playableFormats  = new ArrayList<String>();
    static {
    	exportCallbackMethods();
    }
   
    static public void loadPlayableFormats (Map<String,String> basicVars) {
    	playableFormats.clear();
    	String varString = basicVars.get(VAR_SUPPORTED_FORMATS);
    	if (varString != null ) {
			String encodeFormats[] = varString.split(",");
			for (String format:encodeFormats) {
				playableFormats.add(format);
			}
		}
    }

    static public boolean isPlayableFormatsLoaded () {
    	if (playableFormats.isEmpty())
    		return false;
    	else
    		return true;
    }
    
    static public boolean isPlayable (String fileEncodeFormat) {
    	if ( playableFormats.contains(fileEncodeFormat.trim().toLowerCase()))
    		return true;
    	else
    		return false;
    }

    
    /**
     * Export the java methods that can be called by the flash player
     */
    public static native void exportCallbackMethods() /*-{       
    	$wnd.playerReady = @com.tandbergtv.cms.portal.content.client.title.view.videoplayer.JWPlayerWidget::playerReady(Lcom/google/gwt/core/client/JavaScriptObject;);    
    	$wnd.onPositionChanged = @com.tandbergtv.cms.portal.content.client.title.view.videoplayer.JWPlayerWidget::onPositionChanged(Lcom/google/gwt/core/client/JavaScriptObject;);    
    	$wnd.onStateChanged = @com.tandbergtv.cms.portal.content.client.title.view.videoplayer.JWPlayerWidget::onStateChanged(Lcom/google/gwt/core/client/JavaScriptObject;);    
	}-*/;	   

    
    /**
     * Callback method to be invoked by the flash player after it is initialized.
     * Default name of this callback function is "playerReady"
     * You can also change this callback function with flash variable.
     */
	public static void playerReady(JavaScriptObject jO) { 
		String id = _playerReady(jO);
    } 

    /**
     * Callback method to be invoked by the flash player after each change in the position
     * This is used to set the current position of player.
     * 1st value in the array is the id of the player which will be used to get the player instance
     * The 2nd value is the current position of player. 
     */
	private static void onPositionChanged(JavaScriptObject jObject) { 
		JsArrayString arr = _onPositionChanged(jObject);
		//Window.alert("onPositionChanged:   arr="+arr);
		//Window.alert("onPositionChanged:   Id="+arr.get(0) + "  Position="+arr.get(1));
		JWPlayerWidget player = players.get(arr.get(0));
		player.setPosition(arr.get(1));
	}

    /**
     * Callback method to be invoked by the flash player after a change in the state of the player
     * 1st value in the array is the id of the player which will be used to get the player instance
     * The 2nd value is the old state of player. 
     * The 3rd value is the new state of player. 
     */
	public static void onStateChanged(JavaScriptObject jObject) { 
		JsArrayString arr = _onStateChanged(jObject);
		JWPlayerWidget player = players.get(arr.get(0));
		player.handleStateChanged(arr.get(1),arr.get(2));
	}
	
	
	/**
	 * This function is called when the player is initialized.
	 * The player(JW) version can be obtained from playerObject.version
	 * Use this function to add other listeners 
	*/
	public static native String _playerReady(JavaScriptObject playerObject) /*-{ 
		var id = null;
		var player = $doc.getElementById(playerObject.id);
		if (player) {
			player.addModelListener("TIME", "onPositionChanged");
			player.addModelListener("STATE", "onStateChanged");
			id = playerObject.id;
		}
		
		return id;
	}-*/; 
   
	public static native JsArrayString _onPositionChanged(JavaScriptObject jObject) /*-{
	 	var arr = [];
		arr[0] = jObject.id;
		arr[1] = jObject.position.toString(); //cast to String coz it will not work with different types in the same array
	
		return arr;
	}-*/; 
	
	public static native JsArrayString _onStateChanged(JavaScriptObject jObject) /*-{
		var arr = [];
		arr[0] = jObject.id;
		arr[1] = jObject.oldstate; 
		arr[2] = jObject.newstate; 

		return arr;
	}-*/; 
	
	
	private static native String _getState(String p_ID) /*-{ 
		return $doc.getElementById(p_ID).getConfig().state; 
	}-*/; 

	private static native void _load(String p_ID, String flashVarString) /*-{ 
		return $doc.getElementById(p_ID).sendEvent('LOAD',flashVarString); 
	}-*/; 
	
	private static native void _stop(String p_ID) /*-{ 
	    if ($doc.getElementById(p_ID) == null)
	    	return;
		return $doc.getElementById(p_ID).sendEvent('STOP'); 
	}-*/; 

	
	public static JWPlayerWidget getInstance(String p_Id) {
		return players.get(p_Id);
	}

	public static void setPosition(String p_Id, String position) {
		getInstance(p_Id).setPosition(position);
	}

	static public SWFSettings getSWFSettings (String flashVersionString) {
		SWFSettings swfSettings = new SWFSettings();
		
		if (flashVersionString != null) {
			String vers[] = flashVersionString.split(","); 
			if (vers.length > 2)
				swfSettings.setMinPlayerVersion(new PlayerVersion(Integer.parseInt(vers[0]), Integer.parseInt(vers[1]), Integer.parseInt(vers[2]))); 
			else {
				vers = DEFAULT_MIN_FLASH_VERSION.split(",");
				swfSettings.setMinPlayerVersion(new PlayerVersion(Integer.parseInt(vers[0]), Integer.parseInt(vers[1]), Integer.parseInt(vers[2]))); 
			}
		}
		
		return swfSettings;
	}
	
	public JWPlayerWidget(int width, int height, String swfFile, String flashVersionString, Map<String,String> flashVars, Map<String,String> paramVars) {
		super("cms_contentmgmt_ui/swfs/" + swfFile, width, height,getSWFSettings(flashVersionString));
		initialize (flashVars, paramVars);
	}

	public JWPlayerWidget(Map<String,String> flashVars, Map<String,String> paramVars) {
		super("cms_contentmgmt_ui/swfs/" + DEFAULT_SWF_FILE, DEFAULT_WIDTH, DEFAULT_HEIGHT, getSWFSettings(DEFAULT_MIN_FLASH_VERSION));
		initialize (flashVars, paramVars);
	}

	
    /**
     * Read and set the variables(flashVars,paramVars) that are passed in from the configuration file 
     */
	private void initialize (Map<String,String> flashVars, Map<String,String> paramVars) {
			
		Object keys[] = flashVars.keySet().toArray();
		for (int i=0;i<keys.length;i++) {
			addFlashVar((String)keys[i], flashVars.get(keys[i])); 
		}
		
		//If the "streamer" and "type" flash variable is not configured
		if (flashVars.get(FLASH_VAR_STREAMER) == null && flashVars.get(FLASH_VAR_TYPE) == null )
			addFlashVar(FLASH_VAR_TYPE, "http"); 
		//If the "type" flash variable is not configured, extract it from "streamer" variable
		if (flashVars.get(FLASH_VAR_TYPE) == null)  
			addFlashVar(FLASH_VAR_TYPE, "rtmp"); 
		if (flashVars.get(FLASH_VAR_AUTOSTART) == null)  
			addFlashVar(FLASH_VAR_AUTOSTART, "false"); 
		
		if (flashVars.get(FLASH_VAR_STRETCHING) == null)  
			addFlashVar(FLASH_VAR_STRETCHING, "fill"); 
		if (flashVars.get(FLASH_VAR_FRONT_COLOR) == null)
			addFlashVar(FLASH_VAR_FRONT_COLOR, "86C29D");   // text & icons  (green)
		if (flashVars.get(FLASH_VAR_BACK_COLOR) == null)
			addFlashVar(FLASH_VAR_BACK_COLOR, "003367");    // playlist background (blue)
		if (flashVars.get(FLASH_VAR_LIGHT_COLOR) == null)
			addFlashVar(FLASH_VAR_LIGHT_COLOR, "C286BA");   // selected text/track highlight (red)
	
		keys = paramVars.keySet().toArray();
		for (int i=0;i<keys.length;i++) {
			addParam((String)keys[i], paramVars.get(keys[i])); 
		}
		if (paramVars.get(PARAM_VAR_ALLOWFULLSCREEN) == null)
			addParam(PARAM_VAR_ALLOWFULLSCREEN, "false"); 
		if (paramVars.get(PARAM_VAR_ALLOWSCRIPTACCESS) == null)
			addParam(PARAM_VAR_ALLOWSCRIPTACCESS, "always"); 
		if (paramVars.get(PARAM_VAR_VMODE) == null)
			addParam(PARAM_VAR_VMODE, "opaque"); 
	}
	
	
	protected void onLoad() { 
	    playerId = "JW_" + getSwfId();
		addAttribute("id", playerId);
		addAttribute("name", playerId);

		//Window.alert("Loading JW Player widget " + playerId); 
	    super.onLoad(); 
		players.put(playerId, this);
	}
	
	/*
	This method sends "STOP" event to the player; a workaround for rtmps problem of the player not stopping communication with
	the Helix server after we exit the page.
	*/
	public void close() {
		try{
			_stop(playerId);
		}
		catch(Exception e){
		}		
	}
	
	
	
	@Override
	protected void onUnload() { 
	    //Window.alert("Unloading JW Player widget " + playerId); 
		players.remove(playerId);
		close();
		super.onUnload();
	}

	
	@Override
	public void addAttribute(String attributeName, String attributeValue) { 
		getAttributes().put(attributeName, attributeValue); 
	} 
		
	public void setPosition(String pos) {
		curPosition = pos;
	}

	public String getPosition() {
		return curPosition;
	}
	
	public void handleStateChanged(String oldState, String newState) {
	}

	
	public String getState() {
		return ( _getState(playerId));
	}

	public void reLoad(String flashVarString) {
		_load(playerId,flashVarString);
	}
}
