package com.tandbergtv.cms.portal.content.client.title.view.videoplayer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.tandbergtv.cms.portal.content.client.title.model.UIStillImage;
import com.tandbergtv.cms.portal.content.client.title.service.IVideoPlayerService;
import com.tandbergtv.cms.portal.content.client.title.service.IVideoPlayerServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.keyframes.KeyframesSetImagePanel;

public class SetVideoImagePanel extends KeyframesSetImagePanel{
	private Map<String,String> positionLookup = new HashMap<String,String>();
	protected IVideoPlayerServiceAsync videoPlayerService = GWT.create(IVideoPlayerService.class);	

	public SetVideoImagePanel () {
		super();
	}


	@Override
	public void refreshImagesTable(Long assetId, Long titleId) {

		if (assetId == null) {
			return;
		}
		
		videoPlayerService.getStillImageURIs(assetId, titleId, new AsyncCallback<List<UIStillImage>>() {

			@Override
			public void onFailure(Throwable caught) {
				Window.alert("getSnapshotImageURIs RPC Failure : " + caught);
			}

			@Override
			public void onSuccess(List<UIStillImage> imageInfos) {
				keyframeImagesList.clear();
				positionLookup.clear();
				
				for (UIStillImage imageInfo : imageInfos) {
					String encodedImageFileUri = URL.encodeQueryString(imageInfo.getImageURI());
					final String imageUrl = Window.Location.getProtocol() + "//" + Window.Location.getHost()
							+ GET_IMAGE_JSP_PATH
							+ encodedImageFileUri;

					Image image = new Image(imageUrl);
					image.setWidth("200px");
					image.setHeight("150px");
					keyframeImagesList.add(image);
					positionLookup.put(imageUrl, imageInfo.getTimelinePosition());
				}
				
				displayImages();
			}
			
		});
	}
	
	
	/*
	 * Use "seekToPosition" as image label
	 */
	@Override
	public String getFrameTimeString(String imageUrl) {
		String frameTimeString = "";
		String seekToPosition = positionLookup.get(imageUrl);
		if (seekToPosition != null && !seekToPosition.isEmpty()) {
			frameTimeString = seekToPosition;
		}
		
		return frameTimeString;
	}
	
}
