package com.tandbergtv.cms.portal.content.client.title.view.videoplayer;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.tandbergtv.cms.portal.content.client.tab.ErrorPanel;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFileField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIStringField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UITimeField;
import com.tandbergtv.cms.portal.content.client.title.service.asset.IUIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree.AssetInfo;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UITimeFieldDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class VideoAvailTimeCodePanel extends VideoPanel{

	ButtonWidget timeCodeOneButton; 
    ButtonWidget timeCodeTwoButton; 
	ButtonWidget timeCodeThreeButton; 
    ButtonWidget timeCodeFourButton; 
    TextBoxWidget timeCodeOneTextBox; 
    TextBoxWidget timeCodeTwoTextBox; 
    TextBoxWidget timeCodeThreeTextBox; 
    TextBoxWidget timeCodeFourTextBox; 
    ErrorPanel errorMessagePanel;
    IUIAssetFactory factory = new UIAssetFactory();
    
	protected static final DateTimeFormat TIME_DATE_FORMAT_LOGICAL_CLIP = DateTimeFormat.getFormat("HH:mm:ss");
  
    public VideoAvailTimeCodePanel() {
    	super();
    }
    
     
	void initWidgets() 
	{
		mainContainer = new VerticalContainer();
		mainContainer.addStyleName("VideoAvailTimeCodePanel");
		
		mainContainer.setSpacing(10);
		
		fileListBox = createListBoxWidget();

		errorMessagePanel = new ErrorPanel();
		errorMessagePanel.setVisible(false);
		
		Grid grid = new Grid(4, 3);
		grid.addStyleName("TimeCodeGrid");
	    grid.setCellSpacing(5);
        
	    timeCodeOneTextBox = new TextBoxWidget();
	    timeCodeTwoTextBox = new TextBoxWidget();
	    timeCodeThreeTextBox = new TextBoxWidget();
	    timeCodeFourTextBox = new TextBoxWidget();
	    
	    timeCodeOneButton = new ButtonWidget("Time Code One");
	    timeCodeOneButton.addStyleName("TimeCodeButton");
	    timeCodeOneButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
	    timeCodeOneButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				String formattedTime = getElapsedTimeHoursMinutesSecondsString(playerWidget.getPosition());
				timeCodeOneTextBox.setText(formattedTime);
			}
		});
	    
	    timeCodeTwoButton = new ButtonWidget("Time Code Two");
	    timeCodeTwoButton.addStyleName("TimeCodeButton");
	    timeCodeTwoButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
	    timeCodeTwoButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				String formattedTime = getElapsedTimeHoursMinutesSecondsString(playerWidget.getPosition());
				timeCodeTwoTextBox.setText(formattedTime);
			}
		});
	    
	    timeCodeThreeButton = new ButtonWidget("Time Code Three");
	    timeCodeThreeButton.addStyleName("TimeCodeButton");
	    timeCodeThreeButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
	    timeCodeThreeButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				String formattedTime = getElapsedTimeHoursMinutesSecondsString(playerWidget.getPosition());
				timeCodeThreeTextBox.setText(formattedTime);
			}
		});
	    
	    timeCodeFourButton = new ButtonWidget("Time Code Four");
	    timeCodeFourButton.addStyleName("TimeCodeButton");
	    timeCodeFourButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
	    timeCodeFourButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				String formattedTime = getElapsedTimeHoursMinutesSecondsString(playerWidget.getPosition());
				timeCodeFourTextBox.setText(formattedTime);
			}
		});
	    
	    grid.setWidget(0, 0, timeCodeOneButton);
	    grid.setWidget(0, 1, new LabelWidget(":"));
	    grid.setWidget(0, 2, timeCodeOneTextBox);
	    grid.setWidget(1, 0, timeCodeTwoButton);
	    grid.setWidget(1, 1, new LabelWidget(":"));
	    grid.setWidget(1, 2, timeCodeTwoTextBox);
	    grid.setWidget(2, 0, timeCodeThreeButton);
	    grid.setWidget(2, 1, new LabelWidget(":"));
	    grid.setWidget(2, 2, timeCodeThreeTextBox);
	    grid.setWidget(3, 0, timeCodeFourButton);
	    grid.setWidget(3, 1, new LabelWidget(":"));
	    grid.setWidget(3, 2, timeCodeFourTextBox);
	    
		Button okButton = new Button("Done");
		okButton.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);
		okButton.addClickHandler(new ClickHandler() 
		{
			@Override
			public void onClick(ClickEvent event) {
				UIAsset videoAsset = assetInfo.getAsset();
				UIComplexField rootField = videoAsset.getRootField();
				UIComplexFieldDefinition definition = assetInfo.getDefinition()
						.getRootFieldDefinition();
				
				/* There could be many, change the first one only */
				UIComplexFieldDefinition availsDefn = getFieldDefinition(definition, "Avails");
				UIComplexField availsField = getChildField(rootField, "Avails", availsDefn);
				UIComplexFieldDefinition availDefn = getFieldDefinition(availsDefn, "Avail");
				UIComplexField availField = getChildField(availsField, "Avail", availDefn);

				/* Get the time codes */
				UITimeFieldDefinition code1Defn = getFieldDefinition(availDefn, "TimeCodeOne");
				UITimeField code1Field = getChildField(availField, "TimeCodeOne", code1Defn);
				UITimeFieldDefinition code2Defn = getFieldDefinition(availDefn, "TimeCodeTwo");
				UITimeField code2Field = getChildField(availField, "TimeCodeTwo", code2Defn);
				UITimeFieldDefinition code3Defn = getFieldDefinition(availDefn, "TimeCodeThree");
				UITimeField code3Field = getChildField(availField, "TimeCodeThree", code3Defn);
				UITimeFieldDefinition code4Defn = getFieldDefinition(availDefn, "TimeCodeFour");
				UITimeField code4Field = getChildField(availField, "TimeCodeFour", code4Defn);

				String timeCodeOneFrameTime = timeCodeOneTextBox.getText();
				String timeCodeTwoFrameTime = timeCodeTwoTextBox.getText();
				String timeCodeThreeFrameTime = timeCodeThreeTextBox.getText();
				String timeCodeFourFrameTime = timeCodeFourTextBox.getText();
				
				/* FIXME: Need to check content class before setting values */
				setFieldValue(code1Field, timeCodeOneFrameTime);
				setFieldValue(code2Field, timeCodeTwoFrameTime);
				setFieldValue(code3Field, timeCodeThreeFrameTime);
				setFieldValue(code4Field, timeCodeFourFrameTime);

				playerWidget.close();

				// Redraw asset panel.
				VideoAvailTimeCodePanel.this.assetPanel.redraw(assetInfo);
			}
		});

		HorizontalPanel buttonsPanel = new HorizontalPanel();
		buttonsPanel.addStyleName("ButtonsPanel");

		buttonsPanel.add(okButton);
		Button cancelButton = new Button("Cancel");
		cancelButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		cancelButton.addClickHandler(new ClickHandler() 
		{
			@Override
			public void onClick(ClickEvent event) {
				playerWidget.close();
				// Redraw asset panel.
				VideoAvailTimeCodePanel.this.assetPanel.redraw();
			}
			
		});
		buttonsPanel.add(cancelButton);
				
		playerWidget =  createPlayerWidget("");

		mainContainer.add(fileListBox);
		mainContainer.add(playerWidget);
		mainContainer.add(errorMessagePanel);
		mainContainer.add(grid);
		mainContainer.add(buttonsPanel);
		
		this.setWidget(mainContainer);				
	}
		
	@Override
	protected JWPlayerWidget newPlayerInstance (int width, int height, String swfFile, String flashVersionString, Map<String,String> flashVars, Map<String,String> paramVars) {
		TimeCodePlayer  player = new TimeCodePlayer(width, height, swfFile, flashVersionString, flashVars, paramVars);
		
		List<ButtonWidget> buttons = new ArrayList<ButtonWidget>();
		buttons.add(timeCodeOneButton);
		buttons.add(timeCodeTwoButton);
		buttons.add(timeCodeThreeButton);
		buttons.add(timeCodeFourButton);
		player.setButtons(buttons);
		
		return player;	
	}
	
	void handleValidationError(String errMsg) {
		errorMessagePanel.setWidth("99%");
		errorMessagePanel.showErrorMessage(errMsg);
		errorMessagePanel.setVisible(true);		
	}
	
	
	/**
	 * @param assetInfo the assetInfo to set
	 */
	public void setAssetInfo(AssetInfo assetInfo) {
		this.assetInfo = assetInfo;				
		
		if (initialized == false)
			initialize ();
		else
			refreshView();				
	}

	/**
	 * Refresh the UI components in the view with new assetinfo
	 */
	void refreshView()  {
		errorMessagePanel.setVisible(false);
		if (assetInfo == null)
			return;
		
		// This should be the movie asset.
		UIAsset uiMovieAsset = assetInfo.getAsset();
		
		fileListBox.clear();
		for (UIAssetFile file : uiMovieAsset.getFiles()) {
			UIAssetFileField encodeFormatField = file.getFields().get(FILE_ENCODEFORMAT_XPATH);
			String encodeFormatFieldValue = null;
			if (encodeFormatField != null && encodeFormatField.getField() != null)
				encodeFormatFieldValue = encodeFormatField.getField().getDisplayValue();

			if ((encodeFormatFieldValue == null) || (String.valueOf(encodeFormatFieldValue).isEmpty())) {
				continue;
			}

			UIAssetFileField fileTypeField = file.getFields().get(FILE_FILETYPE_XPATH);
			if ((fileTypeField == null) || (String.valueOf(fileTypeField).isEmpty())) { 
				continue;			
			}
			UIStringField stringField = (UIStringField) fileTypeField.getField();
			String stringFieldValue = stringField.getDisplayValue();
			//Do not include historical files
			if (stringFieldValue.equalsIgnoreCase(FILE_TYPE_HISTORICAL)) {
				continue;
			}

			UIAssetFileField field = file.getFields().get(FILE_URI_XPATH);
			Object fieldValue = field.getField().getDisplayValue();
			if ((fieldValue == null) || (String.valueOf(fieldValue).isEmpty())) {
				continue;
			}
			else {
				String fileEncodeFormat = String.valueOf(encodeFormatFieldValue);
				if (JWPlayerWidget.isPlayable(fileEncodeFormat)) {
					String fileURI = String.valueOf(fieldValue);
					fileListBox.addItem(fileEncodeFormat.trim() + ":" + fileURI);
				}
			}
		}

		if (fileListBox.getItemCount() > 0) {
			fileListBox.setSelectedIndex(0);			
			refreshPlayer(fileListBox.getValue(0));
		}
		
		UIAsset videoAsset = assetInfo.getAsset();
		UIComplexField rootField = videoAsset.getRootField();
		UIComplexField availsField = getChildField(rootField, "Avails", null);
		UIComplexField availField = getChildField(availsField, "Avail", null);
		UITimeField code1Field = getChildField(availField, "TimeCodeOne", null);
		UITimeField code2Field = getChildField(availField, "TimeCodeTwo", null);
		UITimeField code3Field = getChildField(availField, "TimeCodeThree", null);
		UITimeField code4Field = getChildField(availField, "TimeCodeFour", null);

		String code1Time = (code1Field != null) ? code1Field.getDisplayValue() : null;
		String code2Time = (code2Field != null) ? code2Field.getDisplayValue() : null;
		String code3Time = (code3Field != null) ? code3Field.getDisplayValue() : null;
		String code4Time = (code4Field != null) ? code4Field.getDisplayValue() : null;

		if (code1Time != null && !code1Time.isEmpty() && code2Time != null && !code2Time.isEmpty()
				&& code3Time != null && !code3Time.isEmpty() && code4Time != null
				&& !code4Time.isEmpty()) {
			timeCodeOneTextBox.setText(code1Time);
			timeCodeTwoTextBox.setText(code2Time);
			timeCodeThreeTextBox.setText(code3Time);
			timeCodeFourTextBox.setText(code4Time);
		}
	}

	/*  Override to return format that match metadata time format requirement for logical clip
	 */
	public String getElapsedTimeHoursMinutesSecondsString(String timeLinePosition) {
	
		float val =Float.parseFloat(timeLinePosition);
		long  posTimeInMilliseconds =  (long) (val * 1000);
		Date frameDate = TIME_DATE_FORMAT_LOGICAL_CLIP.parse("00:00:00");
		frameDate.setTime(frameDate.getTime() + posTimeInMilliseconds);
	
		String posTimeString = TIME_DATE_FORMAT_LOGICAL_CLIP.format(frameDate);
		//Window.alert("posTimeString=" +posTimeString +  " timeLinePosition= " + timeLinePosition + " befDecVal=" + " posTimeInMilliseconds=" + posTimeInMilliseconds); 
    
		return posTimeString;   
	}  

	/* Get the first child field with matching name, create child field if required */
	@SuppressWarnings("unchecked")
	private <T extends UIField> T getChildField(UIComplexField parent, String childName,
			UIFieldDefinition fieldDefinition) {
		if (parent == null)
			return null;

		UIField field = parent.getChildren().getField(childName);
		if (field == null && fieldDefinition != null) {
			/* Need to use factory to create the field */
			field = factory.createAssetField(fieldDefinition);

			/* FIXME: What about content class application (default value, locked field?) */
		}

		return (T) field;
	}

	/* Get the child field definition with matching name */
	@SuppressWarnings("unchecked")
	private <T extends UIFieldDefinition> T getFieldDefinition(UIComplexFieldDefinition parent,
			String childName) {
		if (parent == null || parent.getChildren() == null)
			return null;

		for (UIFieldDefinition definition : parent.getChildren()) {
			if (definition.getName().equals(childName))
				return (T) definition;
		}

		return null;
	}

	/* Set the field value if hte field exists */
	private void setFieldValue(UITimeField field, String value) {
		if (field != null)
			field.setValue(value);
	}
}
