package com.tandbergtv.cms.portal.content.client.title.view.videoplayer;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.tandbergtv.cms.portal.content.client.tab.ErrorPanel;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFileField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIStringField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UITimeField;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree.AssetInfo;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;


public class VideoLogicalClipPanel extends VideoPanel
{
	ButtonWidget markInButton; 
    ButtonWidget markOutButton; 
    TextBoxWidget markInTextBox; 
    TextBoxWidget markOutTextBox; 
    ErrorPanel errorMessagePanel;
    
	protected static final DateTimeFormat TIME_DATE_FORMAT_LOGICAL_CLIP = DateTimeFormat.getFormat("HH:mm:ss");
  
    public VideoLogicalClipPanel() 
    {
    	super();
    }
    
     
	void initWidgets() 
	{
		mainContainer = new VerticalContainer();
		mainContainer.addStyleName("VideoLogicalClipPanel");
		mainContainer.setSpacing(10);
		
		fileListBox = createListBoxWidget();

		errorMessagePanel = new ErrorPanel();
		errorMessagePanel.setVisible(false);
		
	    markInTextBox = new TextBoxWidget();
	    markOutTextBox = new TextBoxWidget();
	    
        markInButton = new ButtonWidget("Start Time");
	    markInButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);	    
	    markInButton.addClickHandler(new ClickHandler() 
	    {
			public void onClick(ClickEvent event) 
			{
				String formattedTime = getElapsedTimeHoursMinutesSecondsString(playerWidget.getPosition());
				markInTextBox.setText(formattedTime);
			}
		});

	    markOutButton = new ButtonWidget("End Time");
	    markOutButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
	    markOutButton.addClickHandler(new ClickHandler() 
	    {
			public void onClick(ClickEvent event) {
				String formattedTime = getElapsedTimeHoursMinutesSecondsString(playerWidget.getPosition());
				markOutTextBox.setText(formattedTime);
			}
		});

	    HorizontalPanel hc = new HorizontalPanel();
	    hc.add(markInButton);
	    hc.add(new HTML("&nbsp; : &nbsp;"));
	    hc.add(markInTextBox);
	    hc.add(new HTML("&nbsp; &nbsp; &nbsp; &nbsp;"));
	    hc.add(markOutButton);
	    hc.add(new HTML("&nbsp; : &nbsp;"));
	    hc.add(markOutTextBox);
	    hc.addStyleName("ButtonsPanel1");
	    
		HorizontalPanel buttonsPanel = new HorizontalPanel();
		buttonsPanel.addStyleName("ButtonsPanel2");
	    
		Button okButton = new Button("Done");
		okButton.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);
		okButton.addClickHandler(new ClickHandler() 
		{
			@Override
			public void onClick(ClickEvent event) {
				// If Mark-In Mark-out times are selected, set logical clip metadata.
				UIAsset logicalClipUIAsset = assetInfo.getAsset();
				UIComplexField rootField = logicalClipUIAsset.getRootField();
				UIComplexField markField = (UIComplexField) rootField.getChildren().getField("Mark");
				UITimeField markInField = (UITimeField) markField.getChildren().getField("In");
				UITimeField markOutField = (UITimeField) markField.getChildren().getField("Out");
				
				String markInFrameTime = markInTextBox.getText();
				String markOutFrameTime = markOutTextBox.getText();

				Validator util = new Validator();
				if (util.validateMarkInMarkOut(TIME_DATE_FORMAT_LOGICAL_CLIP, markInFrameTime, markOutFrameTime) == false) {
					handleValidationError(util.getMessage());
					return;
				}
				
				markInField.setValue(markInFrameTime);
				markOutField.setValue(markOutFrameTime);
				
				playerWidget.close();
				// Redraw asset panel.
				VideoLogicalClipPanel.this.assetPanel.redraw(assetInfo);
			}
			
		});

		buttonsPanel.add(okButton);
		
		Button cancelButton = new Button("Cancel");
		cancelButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		cancelButton.addClickHandler(new ClickHandler() 
		{
			@Override
			public void onClick(ClickEvent event) {
				playerWidget.close();
				// Redraw asset panel.
				VideoLogicalClipPanel.this.assetPanel.redraw();
			}
			
		});
		buttonsPanel.add(cancelButton);
				
		playerWidget =  createPlayerWidget("");

		mainContainer.add(fileListBox);
		mainContainer.add(playerWidget);
		mainContainer.add(errorMessagePanel);
		mainContainer.add(hc);
		mainContainer.add(buttonsPanel);
		
		this.setWidget(mainContainer);				
	}
		
	@Override
	protected JWPlayerWidget newPlayerInstance (int width, int height, String swfFile, String flashVersionString, Map<String,String> flashVars, Map<String,String> paramVars) {
		TimeCodePlayer  player = new TimeCodePlayer(width, height, swfFile, flashVersionString, flashVars, paramVars);
		
		List<ButtonWidget> buttons = new ArrayList<ButtonWidget>();
		buttons.add(markInButton);
		buttons.add(markOutButton);
		player.setButtons(buttons);
		
		return player;	
	}
	
	void handleValidationError(String errMsg) {
		errorMessagePanel.setWidth("99%");
		errorMessagePanel.showErrorMessage(errMsg);
		errorMessagePanel.setVisible(true);		
	}
	
	
	/**
	 * @param assetInfo the assetInfo to set
	 */
	public void setAssetInfo(AssetInfo assetInfo) {
		this.assetInfo = assetInfo;				
		
		if (initialized == false)
			initialize ();
		else
			refreshView();				
	}

	/**
	 * Refresh the UI components in the view with new assetinfo
	 */
	void refreshView()  {
		errorMessagePanel.setVisible(false);
		if (assetInfo == null)
			return;
		
		// This should be the movie asset.
		UIAsset uiMovieAsset = assetInfo.getAsset().getParentAsset();
		//Long uiMovieAssetId = uiMovieAsset.getId();
		
		fileListBox.clear();
		for (UIAssetFile file : uiMovieAsset.getFiles()) {
			UIAssetFileField encodeFormatField = file.getFields().get(FILE_ENCODEFORMAT_XPATH);
			Object encodeFormatFieldValue = null;
			if (encodeFormatField != null && encodeFormatField.getField() != null)
				encodeFormatFieldValue = encodeFormatField.getField().getDisplayValue();
			
			if ((encodeFormatFieldValue == null) || (String.valueOf(encodeFormatFieldValue).isEmpty())) {
				continue;			
			}
			
			UIAssetFileField fileTypeField = file.getFields().get(FILE_FILETYPE_XPATH);
			if ((fileTypeField == null) || (String.valueOf(fileTypeField).isEmpty())) { 
				continue;			
			}
			UIStringField stringField = (UIStringField) fileTypeField.getField();
			String stringFieldValue = stringField.getDisplayValue();
			//Do not include historical files
			if (stringFieldValue.equalsIgnoreCase(FILE_TYPE_HISTORICAL)) {
				continue;			
			}
			
			UIAssetFileField field = file.getFields().get(FILE_URI_XPATH);
			String fieldValue = field.getField().getDisplayValue();
			if ((fieldValue == null) || (String.valueOf(fieldValue).isEmpty())) {
				continue;
			}
			else {
				String fileEncodeFormat = String.valueOf(encodeFormatFieldValue);
				if (JWPlayerWidget.isPlayable(fileEncodeFormat)) {
					String fileURI = String.valueOf(fieldValue);
					fileListBox.addItem(fileEncodeFormat.trim() + ":" + fileURI);
				}
			}
		}
		
		if (fileListBox.getItemCount() > 0) {
			fileListBox.setSelectedIndex(0);			
			refreshPlayer(fileListBox.getValue(0));
		}
		
		UIAsset logicalClipUIAsset = assetInfo.getAsset();
		UIComplexField rootField = logicalClipUIAsset.getRootField();
		UIComplexField markField = (UIComplexField) rootField.getChildren().getField("Mark");
		UITimeField markInField = (UITimeField) markField.getChildren().getField("In");
		UITimeField markOutField = (UITimeField) markField.getChildren().getField("Out");
		
		String markInTime = markInField.getDisplayValue();
		String markOutTime = markOutField.getDisplayValue();
		
		if ((markInTime != null) && (!markInTime.isEmpty()) && (markOutTime != null) && (!markOutTime.isEmpty())) {
			markInTextBox.setText(markInTime);
			markOutTextBox.setText(markOutTime);
		}
		
	}	
	
	/*  Override to return format that match metadata time format requirement for logical clip
	 */
	public String getElapsedTimeHoursMinutesSecondsString(String timeLinePosition) {
	
		float val =Float.parseFloat(timeLinePosition);
		long  posTimeInMilliseconds =  (long) (val * 1000);
		Date frameDate = TIME_DATE_FORMAT_LOGICAL_CLIP.parse("00:00:00");
		frameDate.setTime(frameDate.getTime() + posTimeInMilliseconds);
	
		String posTimeString = TIME_DATE_FORMAT_LOGICAL_CLIP.format(frameDate);
		//Window.alert("posTimeString=" +posTimeString +  " timeLinePosition= " + timeLinePosition + " befDecVal=" + " posTimeInMilliseconds=" + posTimeInMilliseconds); 
    
		return posTimeString;   
	}  
	
		
}
