package com.tandbergtv.cms.portal.content.client.title.view.videoplayer;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.ListBox;
import com.tandbergtv.cms.portal.content.client.title.model.UIVideoPlayer;
import com.tandbergtv.cms.portal.content.client.title.service.IVideoPlayerService;
import com.tandbergtv.cms.portal.content.client.title.service.IVideoPlayerServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetPanel;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree.AssetInfo;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * Base class that provide the following implementation : a list box for showing a list of playable video files
 * and a JW video player widget to play the selected file.
 * @author bng
 */
public abstract class VideoPanel extends SimpleContainer {
	protected VerticalContainer mainContainer;
	protected AssetPanel assetPanel;
	protected AssetInfo assetInfo;
	protected TitleView titleView;
	protected JWPlayerWidget playerWidget;
    protected ListBox fileListBox;

    //Parameters used by the JW player widget
    protected Map<String,String> basicVars = new HashMap<String,String>();
    protected Map<String,String> flashVars =  new HashMap<String,String>();
    protected Map<String,String> paramVars =  new HashMap<String,String>();

    protected boolean initialized = false;

    protected static final String FILE_URI_XPATH = "/Fields/Locator/Uri";
	protected static final String FILE_ENCODEFORMAT_XPATH = "/Fields/CustomFields/CustomField[@name=EncodeFormat]/@value";
    protected static final String FILE_FILETYPE_XPATH = "/Fields/Locator/Description/Text";
    protected static final String FILE_TYPE_HISTORICAL = "HISTORICAL";
	//Format of the player time-line position
	protected static final DateTimeFormat FRAME_TIME_DATE_FORMAT = DateTimeFormat.getFormat("HH:mm:ss.SSS");

	protected IVideoPlayerServiceAsync videoPlayerService = GWT.create(IVideoPlayerService.class);
	protected TitleViewMessages messages = GWT.create(TitleViewMessages.class);

    public VideoPanel() {
    }

    void initialize () {
    	//Go to backend to fetch player settings
    	fetchPlayerParameters ();
    }

    void fetchPlayerParameters () {
		final BusyIndicator busyIndicator = new BusyIndicator();

		busyIndicator.center();
		//Call rpc service to get player settings from configuration file.
		videoPlayerService.getSettings(new NeptuneAsyncCallback<UIVideoPlayer>() {
					/* Success getting settings */
					public void onNeptuneSuccess(UIVideoPlayer confSettings) {
						busyIndicator.hide();
						basicVars = confSettings.getBasicVars();
						flashVars = confSettings.getFlashVars();
						paramVars = confSettings.getParamVars();

						JWPlayerWidget.loadPlayableFormats (basicVars);
						//todo: Validate flash variable "streamer" before initWidgets
				    	initWidgets();
				    	refreshView();
				    	initialized = true;
					};

					/* Failure getting conf settings from backend */
					public void onNeptuneFailure(Throwable caught) {
						busyIndicator.hide();
						//parentView.handleGetVideoSettingsFailure(caught);
					};
		});

    }

	abstract void initWidgets();
	abstract void refreshView();

	protected ListBox createListBoxWidget() {
		final ListBox listBox = new ListBox();
		listBox.addChangeHandler(new ChangeHandler() {
			public void onChange(ChangeEvent event)
			{
				int selectedIndex = listBox.getSelectedIndex();
				if (selectedIndex > -1) {
					//Window.alert("File Selected: " + listBox.getValue(selectedIndex));
					refreshPlayer(listBox.getValue(selectedIndex));
				}
			}
		});

		return listBox;
	}

	protected JWPlayerWidget createPlayerWidget(String fileURI) {
		//Read the dimensions for the flash player widget
		//If not configured, just use the default one.
	    int width = JWPlayerWidget.DEFAULT_WIDTH;
	    int height = JWPlayerWidget.DEFAULT_HEIGHT;
	    String confWidth = basicVars.get(JWPlayerWidget.VAR_WIDTH);
	    String confHeight = basicVars.get(JWPlayerWidget.VAR_HEIGHT);
		if ( confWidth != null && confHeight != null) {
		    width = Integer.parseInt(confWidth);
		    height = Integer.parseInt(confHeight);
		}

	    String swfFile =  JWPlayerWidget.DEFAULT_SWF_FILE;
		//Read the swf file that is to be used by the flash player
		//If not configured, just use the default one.
		if (basicVars.get(JWPlayerWidget.VAR_SWFFILE) != null)
			swfFile =  basicVars.get(JWPlayerWidget.VAR_SWFFILE);

		//Read the minimum flash plugin version that will work with the flash player
		//If not configured, just use the default one.
		String minFlashVersionString = JWPlayerWidget.DEFAULT_MIN_FLASH_VERSION;
		if (basicVars.get(JWPlayerWidget.VAR_MINFLASHVERSION) != null)
			minFlashVersionString = basicVars.get(JWPlayerWidget.VAR_MINFLASHVERSION);

		if (fileURI != null )
			flashVars.put(JWPlayerWidget.FLASH_VAR_FILE, fileURI);
		flashVars.put(JWPlayerWidget.FLASH_VAR_AUTOSTART,"false"); //set autostart to false

		JWPlayerWidget player = newPlayerInstance(width, height, swfFile, minFlashVersionString, flashVars, paramVars);

		return player;
	}


	protected JWPlayerWidget newPlayerInstance (int width, int height, String swfFile, String flashVersionString, Map<String,String> flashVars, Map<String,String> paramVars) {
		JWPlayerWidget  player = new JWPlayerWidget(width, height, swfFile, flashVersionString, flashVars, paramVars);

		return player;
	}


	/*
	 * Method to call whenever a new file is selected from the list box
	*/
	void refreshPlayer(String fileURI) {
/*
 //It is possible to "load" the player with a new file without recreating the player. Below is sample code:
 //Currently, not able to get it to work, need to spend more time to tune parameters. Can revisit in future.
 //javascript api: player.sendEvent('LOAD',{streamer:'rtmp://localhost/fastplay/',file:'test.flv', type:'video'});
		String streamerStr = JWPlayerWidget.FLASH_VAR_STREAMER + ":" + "\'" + flashVars.get(JWPlayerWidget.FLASH_VAR_STREAMER)+ "\'" ;
		String fileStr = JWPlayerWidget.FLASH_VAR_FILE + ":" + "\'" + fileURI+ "\'" ;
		String typeStr = "type:'rtmp'";
		String flashVarString = "{" + streamerStr + "," + fileStr + "," + typeStr + "}";

		flashVarString = "{streamer:'rtmp://10.232.7.49:1935',file:'flv:/flash/Venice.flv', type:'rtmp'}";
		Window.alert(flashVarString);
		playerWidget.reLoad(flashVarString);
*/

		//Recreate and initialize the player instance.
		int index=1;
		if (playerWidget != null) {
			index = mainContainer.getWidgetIndex(playerWidget);
			mainContainer.remove(playerWidget);
		}
		playerWidget = createPlayerWidget(fileURI);
		mainContainer.insert(playerWidget, index);

	}

	/*  Method to format the time position so that it is more readable and in format that is also required
		by the ffmpeg backend operations
	*/
	public String getElapsedTimeHoursMinutesSecondsString(String timeLinePosition) {

		float val =Float.parseFloat(timeLinePosition);
		long  posTimeInMilliseconds =  (long) (val * 1000);
		Date frameDate = FRAME_TIME_DATE_FORMAT.parse("00:00:00.000");
		frameDate.setTime(frameDate.getTime() + posTimeInMilliseconds);

		String posTimeString = FRAME_TIME_DATE_FORMAT.format(frameDate);
	    //Window.alert("posTimeString=" +posTimeString +  " timeLinePosition= " + timeLinePosition + " befDecVal=" + " posTimeInMilliseconds=" + posTimeInMilliseconds);

	    return posTimeString;
	}

	/**
	 * @return the assetPanel
	 */
	public AssetPanel getAssetPanel() {
		return assetPanel;
	}

	/**
	 * @param assetPanel the assetPanel to set
	 */
	public void setAssetPanel(AssetPanel assetPanel) {
		this.assetPanel = assetPanel;

		//refreshImagesTable();
	}

	/**
	 * @param titleView the titleView to set
	 */
	public void setTitleView(TitleView titleView) {
		this.titleView = titleView;
	}

}
