package com.tandbergtv.cms.portal.content.client.title.view.videoplayer;
import java.util.Map;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.DockPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * Dialog used to preview video files
 * Main component is the video player widget.  
 * 
 * @author bng
 */
public class VideoPreviewDialog extends DialogBox {
	private JWPlayerWidget player;
	
	public VideoPreviewDialog(String videoFile, Map<String,String> basicVars, Map<String,String> flashVars,Map<String,String> paramVars) {
		setText("Preview of "+ videoFile);

		DockPanel dock = new DockPanel();
	    dock.setSpacing(4);
		
		//Read the dimensions for the flash player widget
		//If not configured, just use the default one.
	    int width = JWPlayerWidget.DEFAULT_WIDTH;
	    int height = JWPlayerWidget.DEFAULT_HEIGHT;
	    String confWidth = basicVars.get(JWPlayerWidget.VAR_WIDTH);
	    String confHeight = basicVars.get(JWPlayerWidget.VAR_HEIGHT);
		if ( confWidth != null && confHeight != null) {
		    width = Integer.parseInt(confWidth);
		    height = Integer.parseInt(confHeight);			
		}
		
	    String swfFile =  JWPlayerWidget.DEFAULT_SWF_FILE;
		//Read the swf file that is to be used by the flash player
		//If not configured, just use the default one.
		if (basicVars.get(JWPlayerWidget.VAR_SWFFILE) != null)
			swfFile =  basicVars.get(JWPlayerWidget.VAR_SWFFILE);
		
		//Read the minimum flash plugin version that will work with the flash player
		//If not configured, just use the default one.
		String minFlashVerionString = JWPlayerWidget.DEFAULT_MIN_FLASH_VERSION;
		if (basicVars.get(JWPlayerWidget.VAR_MINFLASHVERSION) != null)
			minFlashVerionString = basicVars.get(JWPlayerWidget.VAR_MINFLASHVERSION); 
		
		if (videoFile != null )
			flashVars.put(JWPlayerWidget.FLASH_VAR_FILE,videoFile); 
		flashVars.put(JWPlayerWidget.FLASH_VAR_AUTOSTART,"true"); //for this dialog, set autostart to true
		
		//Window.alert("swfFile=" + swfFile + " minFlashVerionString = " + minFlashVerionString  + "  flashVars=" + flashVars.toString() +
		//		 "  paramVars="+paramVars.toString());
		player = new JWPlayerWidget(width, height, swfFile, minFlashVerionString, flashVars, paramVars);
	    
	    
		ButtonWidget closeButton = new ButtonWidget("Close");
		closeButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		closeButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				hide();
			}
		});
		
		HorizontalContainer hc = new HorizontalContainer();
	    hc.setSpacing(5);
	    
	    dock.add(player, DockPanel.NORTH);
		dock.add(closeButton, DockPanel.SOUTH);
		dock.add(hc, DockPanel.SOUTH);

		dock.setCellHorizontalAlignment(closeButton, DockPanel.ALIGN_RIGHT);		
		dock.setWidth("100%");
	    setWidget(dock);		
		
	}

	
}
