package com.tandbergtv.cms.portal.content.client.title.view.videoplayer;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.tandbergtv.cms.portal.content.client.tab.ErrorPanel;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFileField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIStringField;
import com.tandbergtv.cms.portal.content.client.title.view.activity.TitleActivityTab;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree.AssetInfo;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.InlineLabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class VideoSnapshotPanel extends VideoPanel
{
	FlowPanel requestSuccessMessagePanel;
	ErrorPanel requestErrorMessagePanel;
	ButtonWidget snapshotButton; 

	private String SUCCESS_MESSAGE_STYLE1 = "content-TitleView-feedbackPopup" ; 
	private String SUCCESS_MESSAGE_STYLE2 = "content-TitleView-feedbackLabel"; 
	
    public VideoSnapshotPanel() 
    {
    	super();
    }
   
	void initWidgets() 
	{
		mainContainer = new VerticalContainer();
		mainContainer.addStyleName("VideoSnapshotPanel");
		mainContainer.setSpacing(10);

		requestSuccessMessagePanel = new FlowPanel(); 
		InlineLabelWidget activityViewLabel = new InlineLabelWidget(messages.activityTabName());
		activityViewLabel.addStyleName(TableConstants.STYLE_DATA_LINK);
		activityViewLabel.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				titleView.showTab(TitleActivityTab.TAB_NAME);;
			}
		});
		
		String msg = messages.snapshotImageProcessInitiatedText();
		InlineLabelWidget targetingInitiatedLabel1 = new InlineLabelWidget(msg);
		addSuccessStyleForLabel(targetingInitiatedLabel1);
		addSuccessStyleForLabel(activityViewLabel);
		requestSuccessMessagePanel.add(targetingInitiatedLabel1);	
		requestSuccessMessagePanel.add(activityViewLabel);
		requestSuccessMessagePanel.setVisible(false);
		
		requestErrorMessagePanel = new ErrorPanel();
		requestErrorMessagePanel.setVisible(false);
		// or else right border doesn't show up
		requestErrorMessagePanel.setWidth("99%");
		
		fileListBox = createListBoxWidget();

	    snapshotButton = new ButtonWidget(messages.createSnapshotButtonText());
	    snapshotButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
	    snapshotButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				String formattedTime = getElapsedTimeHoursMinutesSecondsString(playerWidget.getPosition());
				String state = playerWidget.getState();
				if (state.equals(JWPlayerWidget.STATE_PAUSED) == false) {
					Window.alert("Please pause the player first.");
					return;
				}
				UIAsset uiMovieAsset = assetInfo.getAsset();
				Long uiMovieAssetId = uiMovieAsset.getId();
				Long titleId = assetInfo.getInput().getTitleId();
				//String providerId = titleView.getInput().getTitle().getContentClassMetadata().getProviderId();
				String providerId = assetInfo.getDefinition().getSpecification().getProviderId();
				int selectedIndex = fileListBox.getSelectedIndex();
				String selectedFile= fileListBox.getValue(selectedIndex);
				String fileURI=selectedFile;
				int index = selectedFile.indexOf(":");
				if (index > 0)
					fileURI = selectedFile.substring(index+1);
				submitRequest (uiMovieAssetId, titleId, providerId, fileURI, formattedTime);
			}
		});

		Button okButton = new Button(messages.videoSnapshotOkButtonText());
		okButton.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);
		okButton.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				playerWidget.close();
				// Redraw asset panel.
				VideoSnapshotPanel.this.assetPanel.redraw();
			}
			
		});

		HorizontalPanel buttonsPanel = new HorizontalPanel();
		buttonsPanel.addStyleName("ButtonsPanel");
		buttonsPanel.add(okButton);
		buttonsPanel.add(snapshotButton);
		
		playerWidget = createPlayerWidget("");

		mainContainer.add(requestSuccessMessagePanel);
		mainContainer.add(requestErrorMessagePanel);
		mainContainer.add(fileListBox);
		mainContainer.add(playerWidget);
		mainContainer.add(buttonsPanel);
		
		this.setWidget(mainContainer);					    
	}	
	
	private void addSuccessStyleForLabel(InlineLabelWidget labelWidget) {
		labelWidget.addStyleName(SUCCESS_MESSAGE_STYLE1);
		labelWidget.addStyleName(SUCCESS_MESSAGE_STYLE2);
	}
	
	
	/**
	 * @param assetInfo the assetInfo to set
	 */
	public void setAssetInfo(AssetInfo assetInfo) {
		this.assetInfo = assetInfo;
		
		//Check if it is initialized. Initialize require backend trip to get player settings  
		if (initialized == false)
			initialize ();
		else
			refreshView();				
	}

	void refreshView()  {

		if (assetInfo == null)
			return;
		
		fileListBox.clear();
		// This should be the movie asset.
		UIAsset uiMovieAsset = assetInfo.getAsset();
		for (UIAssetFile file : uiMovieAsset.getFiles()) {
			UIAssetFileField encodeFormatField = file.getFields().get(FILE_ENCODEFORMAT_XPATH);
			Object encodeFormatFieldValue = null;
			if (encodeFormatField != null && encodeFormatField.getField() != null)
				encodeFormatFieldValue = encodeFormatField.getField().getDisplayValue();
			
			if ((encodeFormatFieldValue == null) || (String.valueOf(encodeFormatFieldValue).isEmpty())) {
				continue;			
			}

			UIAssetFileField fileTypeField = file.getFields().get(FILE_FILETYPE_XPATH);
			if ((fileTypeField == null) || (String.valueOf(fileTypeField).isEmpty())) { 
				continue;			
			}
			UIStringField stringField = (UIStringField) fileTypeField.getField();
			String stringFieldValue = stringField.getDisplayValue();
			//Do not include historical files
			if (stringFieldValue.equalsIgnoreCase(FILE_TYPE_HISTORICAL)) {
				continue;			
			}
  
			UIAssetFileField field = file.getFields().get(FILE_URI_XPATH);
			Object fieldValue = field.getField().getDisplayValue();
			if ((fieldValue == null) || (String.valueOf(fieldValue).isEmpty())) {
				continue;
			}
			else {
				String fileEncodeFormat = String.valueOf(encodeFormatFieldValue);
				if (JWPlayerWidget.isPlayable(fileEncodeFormat)) {
					String fileURI = String.valueOf(fieldValue);
					fileListBox.addItem(fileEncodeFormat.trim() + ":" + fileURI);
				}
			}
		}

		requestSuccessMessagePanel.setVisible(false);		
		requestErrorMessagePanel.setVisible(false);		
		if (fileListBox.getItemCount() > 0) {
			fileListBox.setSelectedIndex(0);			
			refreshPlayer(fileListBox.getValue(0));
		}		
	}
	
	
	/**
	 * Submit request to the backend (create workorder ) to generate image file from video file using ffmpeg
	 */
    void submitRequest (final Long assetId, Long titleId, String providerId, String fileURI, String timePosition) {
		final BusyIndicator busyIndicator = new BusyIndicator(this);
		busyIndicator.center();
				
		videoPlayerService.createImageFromVideoFile(assetId, titleId, providerId, fileURI, timePosition,
		        new NeptuneAsyncCallback<Void>() {
			        @Override
			        public void onNeptuneSuccess(Void result) {
						busyIndicator.hide();
				        handleSubmitRequestSuccess(assetId);
			        }

			        @Override
			        public void onNeptuneFailure(Throwable caught) {
						busyIndicator.hide();
			        	handleSubmitRequestFailure(caught);
			        }
		});
				
		return;
    }
	
    void handleSubmitRequestSuccess(Long assetId) {
		requestSuccessMessagePanel.setVisible(true);		   	
    }

    void handleSubmitRequestFailure(Throwable caught) {
    	requestErrorMessagePanel.showErrorMessage(caught.getMessage());
    	requestSuccessMessagePanel.setVisible(false);	
		requestErrorMessagePanel.setVisible(true);
    }
    
}
