package com.ericsson.cms.contractmgmt.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.ericsson.cms.contractmgmt.client.services.AddAssetToLicense;
import com.ericsson.cms.contractmgmt.client.tab.audit.AuditView;
import com.ericsson.cms.contractmgmt.client.tab.config.ConfigurationView;
import com.ericsson.cms.contractmgmt.client.tab.contract.ContractListPanel;
import com.ericsson.cms.contractmgmt.client.tab.copyrightholder.CopyrightHolderListPanel;
import com.ericsson.cms.contractmgmt.client.tab.deal.DealListPanel;
import com.ericsson.cms.contractmgmt.client.tab.license.LicenseListPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;

public class ContractComponent extends ComponentBase {
    /** The Contract Manager Component Name */
    public static final String COMPONENT_NAME = "Contract Manager";
    
    private static final String SCHEDULER_LICENSE_KEY = "SchedulerLicense";

    /* The values for the user properties loaded during initialization */
    private final ContractComponentConstants constants = GWT.create( ContractComponentConstants.class );
    private boolean schedulerLicensed;
    private static ContractComponent instance = new ContractComponent();

    /**
     * Constructor
     */
    private ContractComponent() {
    }

    // ========================================================================
    // ===================== COMPONENT METHODS
    // ========================================================================

	/**
	 * @return the instance
	 */
	public static ContractComponent getInstance() {
		return instance;
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase#init(com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry, com.tandbergtv.neptune.widgettoolkit.client.event.EventSink, com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader, java.util.Map)
	 */
	@Override
	public void init(EventListenerRegistry eventListenerRegistry,
			EventSink eventSink, ServiceLoader serviceLoader,
			Map<String, String> info) {
		super.init(eventListenerRegistry, eventSink, serviceLoader, info);
		
		this.schedulerLicensed = Boolean.parseBoolean(info.get(SCHEDULER_LICENSE_KEY));
	}

    @Override
    public List<PortletFactory> listPortlets( NeptuneSecurity security ) {
        List<PortletFactory> portletFactories = new ArrayList<PortletFactory>();

        return portletFactories;
    }

    @SuppressWarnings("unchecked")
	@Override
    public <E extends Service> List<E> listServices( Class<E> clazz, NeptuneSecurity security ) {
        if ( clazz.getName().equalsIgnoreCase( ITitleService.class.getName() ) ) {
            List<ITitleService> listServices = new ArrayList<ITitleService>();
            if ( ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY ) ) {
                listServices.add( new AddAssetToLicense() );
            }
            return (List<E>) listServices;
        }

        return null;
    }

    // ========================================================================
    // ===================== Contract Manager - MENU ITEMS
    // ========================================================================

    @Override
    public List<MenuItemBase> listTabs( final NeptuneSecurity security ) {
        List<MenuItemBase> tabs = new ArrayList<MenuItemBase>();

        /* Build the menu items for the 'contract' entity */
        MenuItemBase menuItem = buildContractManagerMenuItem();
        if ( menuItem != null ) {
        	tabs.add( menuItem );
        }

        return tabs;
    }

    // ========================================================================
    // ===================== CONTRACT MANAGER MENU ITEMS
    // ========================================================================

    /*
     * Build the menu items used to manage contracts
     */
    private MenuItemBase buildContractManagerMenuItem() {
        List<MenuItemBase> contractManagerGroup = new ArrayList<MenuItemBase>();
        String displayName = constants.menuItemContractManager();
        GroupMenuItem menuItem = new GroupMenuItem( "Contracts", displayName, contractManagerGroup );

        // if the user does not have view or create permissions return back.
        if ( ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_VIEW ) ) {
            // add copyright menu
            final CopyrightHolderListPanel copyrightHolderListPanel = new CopyrightHolderListPanel();
            WidgetMenuItem copyrightHolderView = new WidgetMenuItem( "Copyright", constants.menuItemCopyright(), new WidgetFactory() {
                        public Widget getInstance() {
                            return copyrightHolderListPanel;
                        }

                        public void release( Widget widget ) {
                        }
                    }, copyrightHolderListPanel.getAnchorChangeListener() );
            copyrightHolderListPanel.setReverseAnchorChangeListener( copyrightHolderView.getReverseAnchorChangeListener() );
            contractManagerGroup.add( copyrightHolderView );

            // add contract menu
            final ContractListPanel contractListPanel = new ContractListPanel();
            WidgetMenuItem contractView = new WidgetMenuItem( "Contract", constants.menuItemContract(), new WidgetFactory() {
                        public Widget getInstance() {
                            return contractListPanel;
                        }

                        public void release( Widget widget ) {
                        }
                    }, contractListPanel.getAnchorChangeListener() );
            contractListPanel.setReverseAnchorChangeListener( contractView.getReverseAnchorChangeListener() );
            contractManagerGroup.add( contractView );

            // add deal menu
            final DealListPanel dealListPanel = new DealListPanel();
            WidgetMenuItem dealView = new WidgetMenuItem( "Deal", constants.menuItemDeal(), new WidgetFactory() {
                        public Widget getInstance() {
                            return dealListPanel;
                        }

                        public void release( Widget widget ) {
                        }
                    }, dealListPanel.getAnchorChangeListener() );
            dealListPanel.setReverseAnchorChangeListener( dealView.getReverseAnchorChangeListener() );
            contractManagerGroup.add( dealView );

            // add license menu
            final LicenseListPanel licenseListPanel = new LicenseListPanel();
            WidgetMenuItem licenseView = new WidgetMenuItem( "License", constants.menuItemLicense(), new WidgetFactory() {
                        public Widget getInstance() {
                            licenseListPanel.clearMessages();
                            return licenseListPanel;
                        }

                        public void release( Widget widget ) {
                        }
                    }, licenseListPanel.getAnchorChangeListener() );
            licenseListPanel.setReverseAnchorChangeListener( licenseView.getReverseAnchorChangeListener() );
            contractManagerGroup.add( licenseView );

            // add configuration menu
            final ConfigurationView configurationView = new ConfigurationView();
            WidgetMenuItem configurationMenuItem = new WidgetMenuItem( "Configuration", constants.menuItemConfiguration(), new WidgetFactory() {
                        public Widget getInstance() {
                            return configurationView;
                        }

                        public void release( Widget widget ) {
                        }
                    }, configurationView.getAnchorChangeListener() );
            contractManagerGroup.add( configurationMenuItem );
            
            // add Audit menu
             final AuditView auditView = new AuditView();
             WidgetMenuItem auditWidget = new WidgetMenuItem( "Audit", constants.menuItemAudit(), new WidgetFactory() {
                         public Widget getInstance() {
                             return auditView;
                         }

                         public void release( Widget widget ) {
                         }
                     });
             contractManagerGroup.add( auditWidget );
        }

        return menuItem;
    }

    @Override
    public String getName() {
        return "CONTRACT_MANAGER";
    }

    @Override
    public String getDisplayName() {
        return constants.componentDisplayName();
    }

	/**
	 * @return the schedulerLicensed
	 */
	public boolean isSchedulerLicensed() {
		return this.schedulerLicensed;
	}
}
