/*
 * Created on May 14, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.ericsson.cms.contractmgmt.client;

import com.google.gwt.i18n.client.Messages;

/**
 * Messages used when building the contract component
 * 
 * @author Daniel Paranhos
 */
public interface ContractComponentMessages extends Messages {

    String numberValidationErrorTooltip();
    String positiveNumberValidationErrorTooltip();
    String floatValidationErrorTooltip();
    String alphaNumericValidationErrorTooltip();
    String minCharsValidationErrorTooltip( int minChars );
    String maxCharsDefaultValidationErrorTooltip(int max);
    String maxCharsValidationErrorTooltip(int max);
    String fieldRequiredValidationErrorTooltip();
    String deleteLicenseConfirmation();
    String deleteLicenseError();
    String deleteLicenseSucceeded();
    String saveLicenseError();
    String saveLicenseSucceeded( String name );
    String invalidFormError();
    String noLicenseSelected();
    String removePlatformConfirmation( String platform );
    String pricingTabBuyRate();
    String pricingTabLostBuys();
    String pricingTabRevenueShare();
    String pricingTabToDateBeforeFrom( String type, int row );
    String pricingTabLicenseEffectiveAfterFromDate( String type, int row, String date );
    String pricingTabLicenseExpiryBeforeToDate( String type, int row, String date );
    String storageDateMessage(String date);
    String invalidFieldValue( String field );
    String distributionManagementUniqueViolation();
    String tabsValidationError();
    String dataLossConfirmation();
    String dateNotWithinError( int x, String field, String date1, String date2 );
    String deliveryDateRequired();
    String deliveryDateNotBeforeReturn();
    String deliveryDateBeforeDue();
    String formHasValidationErrors();
    String licenseFormHasValidationErrors();
    String paymentFormHasValidationErrors();
    String tieredPricingFormHasValidationErrors();
    String revenueShareFormHasValidationErrors();
    String maxFieldLength( String string, int i );
    String dateNotAfterError( String date1, String date2, String date2Value );
    String dateAfterError( String date1, String date2, String date2Value );
    String dateNotBeforeError( String date1, String date2, String date2Value );
    String dateBeforeError( String date1, String date2, String date2Value );
    String deliveryLocationNotSelected();
    String platformNotSelected();
    String deleteFieldConfirmation();
    String deleteFieldError();
    String deleteFieldSucceeded();
    String saveFieldError();
    String saveFieldSucceeded();
    String noFieldSelected();
    String licenseRequiredFailure();
    String deleteGenericConfirmation(); 
    String deleteGenericError(); 
    String deleteGenericSucceeded();
    String saveGenericError(); 
    String saveGenericSucceeded();
    String noGenericSelected(); 
    String deleteDropDownConfirmation();
    String deleteDropDownError();
    String deleteDropDownSucceeded();
    String saveDropDownError();
    String saveDropDownSucceeded();
    String noDropDownSelected();
    String assetSelectionRequired();
    String uploadError();
    String assetsSelectionAfterSave();
    String upfrontPaymentRequired();
    String overageRequired();
    String installmentPlanRequired();
    String deleteCopyrightHolderConfirmation();
    String deleteCopyrightHolderError();
    String deleteCopyrightHolderSucceeded();
    String saveCopyrightHolderError();
    String saveCopyrightHolderSucceeded();
    String noCopyrightHolderSelected();
    String deleteDealConfirmation();
    String deleteDealError();
    String deleteDealSucceeded();
    String saveDealError();
    String saveDealSucceeded();
    String noDealSelected();
    String deleteContractConfirmation();
    String deleteContractError();
    String deleteContractSucceeded();
    String saveContractError();
    String saveContractSucceeded();
    String noContractSelected();
    String treeDefaultNodeWarning();
    String deleteRecordConfirmation();
    String noRecordSelected();
    String positiveFloatValidationErrorTooltip();
    String defaultValueRequired();
    String defaultValueNotInDropDown();
    String defaultValueNotNumber(Long maxVal);
    String defaultValueBetween0And100();
    String defaultValueNotPercentage();
    String defaultValueDateFormat(String dateFormat);
    String maxGreaterThanMin(int maxLength, int minLength);
    String defaultValueMinLength(int minLength);
    String defaultValueMaxLength(int maxLength);
    String pricingTabPriceRequired(String type, int row, String field);
    String pricingTabThresholdOrDateRangeRequired( String type, int i );
    String pricingTabDatesOverlap( String type );
    String pricingTabDatesThresholdOverlap(String type);
    String licenseTabNotChangedConfirm();
    String saveContactSameEmail();
    String fileSize();
    String dropDownSelectionAfterSave();
    String contractDealCreationDateValidation(String dealName);
    String contractDealEffectiveDateValidation(String dealName);
    String contractDealExpiryDateValidation(String dealName);
    String dealLicenseExpiryDateValidation(String licenseName);
    String dealLicenseEffectiveDateValidation(String licenseName);
    String dealLicenseCreationDateValidation(String licenseName);
	String saveScheduleSucceeded();
	String deleteScheduleSucceeded();    
}   