package com.ericsson.cms.contractmgmt.client.customfield;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.ValueFormatException;

/**
 * Validates an alpha numeric value
 * 
 * @author Daniel Paranhos
 */
public class AlphaNumericValidator implements IValueConverter<String> {

    /**
     * Constructor
     */
    public AlphaNumericValidator() {
    }

    @Override
    public String getStringValue( String typedValue ) {
        return typedValue;
    }

    @Override
    public String getTypedValue( String value ) throws ValueFormatException {
        if (value != null && !value.trim().equals("") && !value.matches("[0-9a-zA-Z ]*")) {
            throw new ValueFormatException(value + " is not a valid alpha numeric text.");
        }

        return value;
    }
}
