package com.ericsson.cms.contractmgmt.client.customfield;

public enum AuditTypeEnum {
	CONTRACT ("Contract",new Long(10l)),
	COPYRIGHT ("Copyright",new Long(20l)),
    DEAL ("Deal",new Long(30l)),
    LICENSE ("License",new Long(40l));
    
	 private String text;
    private Long value;
    AuditTypeEnum(String text,Long value) {
    	this.text = text;
    	this.value = value;
    }
    
    AuditTypeEnum() {
    }
    
    @Override
    public String toString() {
        return this.text;
    }

    public Long getValue(){
    	return this.value;
    }
    
    public static String getTextByValue(Long value){
    	String text;
    	switch (value.intValue()){
    	
    	case 10: text = "Contract";
        break;
    	case 20: text = "Copyright";
        break;
    	case 30: text = "Deal";
        break;
    	case 40: text = "License";
        break;
    	default: text = "Invalid Value: "+ value.toString();
        break;
    	
    	}
    	return text;
    }
}
