package com.ericsson.cms.contractmgmt.client.customfield;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

import com.ericsson.cms.contractmgmt.client.Changeable;
import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.tab.config.PercentageConverter;
import com.ericsson.cms.contractmgmt.client.tab.license.tab.TabValueChangeHandler;
import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.StringConverter;

public class CustomFieldFactory {

    public static final String COPYRIGHT_HOLDER_SCREEN = "COPYRIGHTHOLDER";
    public static final String CONTRACT_SCREEN = "CONTRACT";
    public static final String DEAL_SCREEN = "DEAL";
    public static final String LICENSE_SCREEN = "LICENSE";
    public static final String DISTRIBUTION_SCREEN = "DISTRIBUTION";
    public static final String STORAGE_METADATA_SCREEN = "STORAGE_METADATA";
    public static final String ASSET_ENHANCEMENT_SCREEN = "ASSET_ENHANCEMENT";
    public static final String PRICING_SCREEN = "PRICING";
    private final Changeable changeable;

    private final ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );

    private final ContractComponentMessages messages = (ContractComponentMessages) GWT
            .create( ContractComponentMessages.class );

    public CustomFieldFactory( Changeable changeable ) {
        this.changeable = changeable;
    }

    public TypedTextBoxWidget<?> createTextField( UiUserDefinedField userDefinedField ) {
        TypedTextBoxWidget<?> textBox = createTypedTextBox( userDefinedField );

        Integer maxChars = userDefinedField.getMaxChars();
        if (userDefinedField.isDropDown() == null || !userDefinedField.isDropDown() && maxChars != null && maxChars > 0) {
            textBox.setMaxLength(maxChars);
        }

        String defaultValue = userDefinedField.getDefaultValue();
        if ( defaultValue != null && !defaultValue.trim().equals( "" ) ) {
            textBox.setTextValue( defaultValue );
        }

        return textBox;
    }

    private TypedTextBoxWidget<?> createTypedTextBox( UiUserDefinedField userDefinedField ) {
        if ( FieldTypeEnum.Number.equals( userDefinedField.getType() ) ) {
            TypedTextBoxWidget<Long> textBoxLong = new TypedTextBoxWidget<Long>( new IntegerConverter() );
            textBoxLong.addValueChangeHandler( new TabValueChangeHandler<Long>( changeable ) );
            textBoxLong.setErrorToolTip( messages.numberValidationErrorTooltip() );

            return textBoxLong;
        } else if ( FieldTypeEnum.Percentage.equals( userDefinedField.getType() ) ) {
            TypedTextBoxWidget<String> textBoxString = new TypedTextBoxWidget<String>( new PercentageConverter() );
            textBoxString.setErrorToolTip( messages.positiveFloatValidationErrorTooltip() );
            textBoxString.addValueChangeHandler( new TabValueChangeHandler<String>( changeable ) );

            return textBoxString;
        } else {
            TypedTextBoxWidget<String> textBoxString = new TypedTextBoxWidget<String>( new StringConverter() );
            if ( FieldTypeEnum.Alphanumeric.equals( userDefinedField.getType() ) ) {
                textBoxString = new TypedTextBoxWidget<String>( new AlphaNumericValidator() );
                textBoxString.setErrorToolTip( messages.alphaNumericValidationErrorTooltip() );
            }
            textBoxString.addValueChangeHandler( new TabValueChangeHandler<String>( changeable ) );
            return textBoxString;
        }
    }

    public TypedDateBoxWidget createDateField( UiUserDefinedField userDefinedField ) {
        TypedDateBoxWidget dateBox = new TypedDateBoxWidget( new DateConverter( constants.dateFormat(),
                constants.dateFormat() ) );

        dateBox.getTextBox().setMaxLength( constants.dateFormat().length() );
        dateBox.getTextBox().setVisibleLength( constants.dateFormat().length() );
        dateBox.setToolTip( constants.validDateTitle() + " " + constants.dateFormat() );
        dateBox.setErrorToolTip( constants.validDateTitle() + " " + constants.dateFormat() );

        String defaultValue = userDefinedField.getDefaultValue();
        if ( defaultValue != null ) {
            dateBox.setTextValue( defaultValue.trim() );
        }

        dateBox.addValueChangeHandler( new TabValueChangeHandler<String>( changeable ) );

        return dateBox;
    }

    public TypedListBoxWidget<String> createListBoxField( UiUserDefinedField userDefinedField ) {
        TypedListBoxWidget<String> listBox = new TypedListBoxWidget<String>( new StringConverter() );
        List<UiKeyName> uiKeyNamesList = new ArrayList<UiKeyName>( userDefinedField.getKeyNames() );
        Collections.sort( uiKeyNamesList, new Comparator<UiKeyName>() {

            @Override
            public int compare( UiKeyName ukn1, UiKeyName ukn2 ) {
                return ukn1.getName().compareTo( ukn2.getName() );
            }
        } );

        listBox.addItem( "", null );
        for ( UiKeyName keyName : uiKeyNamesList ) {
            listBox.addItem( keyName.getName(), keyName.getKey().toString() );
        }

        String defaultValue = userDefinedField.getDefaultValue();
        if ( defaultValue != null && !defaultValue.trim().equals( "" ) ) {
            listBox.setSelectedItem( defaultValue );
        }

        listBox.addValueChangeHandler( new TabValueChangeHandler<String>( changeable ) );

        return listBox;
    }

    public void addFieldsToForm( FormContainer form, List<UiUserDefinedField> userDefinedFields,
            Map<DataTypeWidget<?>, UiUserDefinedField> widgetCustomFieldMap ) {
        if (!userDefinedFields.isEmpty()) {
            form.addRow("User Defined Fields:", new LabelWidget());
        }
        for ( UiUserDefinedField field : userDefinedFields ) {
            DataTypeWidget<?> widget = null;
            switch ( field.getType() ) {
            case Number:
            case Percentage:
                widget = createTextField( field );
                break;
            case Text:
            case Alphanumeric:
                if ( field.isDropDown() != null && field.isDropDown() ) {
                    widget = createListBoxField( field );
                } else {
                    widget = createTextField( field );
                }
                break;
            case Currency:
            case Frequency:
                widget = createListBoxField( field );
                break;
            case Date:
                widget = createDateField( field );
                break;
            }

            if ( widget != null ) {
                form.addRow( field.getLabel(), widget, field.isRequired() != null && field.isRequired() );
                widgetCustomFieldMap.put( widget, field );
            }
        }

    }

}
