package com.ericsson.cms.contractmgmt.client.customfield;

import java.util.HashSet;
import java.util.Set;

import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.google.gwt.user.client.rpc.IsSerializable;

public class UiUserDefinedField implements IsSerializable {

    private Long idUserDefinedField;
    private String screenName;
    private FieldTypeEnum type;
    private String label;
    private String defaultValue;
    private Integer order;
    private Boolean required;
    private Boolean isDropDown;
    private Integer minChars;
    private Integer maxChars;
    private Set<UiKeyName> keyNames;

    public UiUserDefinedField() {
        keyNames = new HashSet<UiKeyName>();
    }
    
    public UiUserDefinedField( String screenName ) {
        this();
        this.screenName = screenName;
    }

    /**
     * Get the id
     * 
     * @return the id
     */
    public Long getIdUserDefinedField() {
        return idUserDefinedField;
    }

    /**
     * Set the id
     * 
     * @param idUserDefinedField
     *            the id
     */
    public void setIdUserDefinedField( Long idUserDefinedField ) {
        this.idUserDefinedField = idUserDefinedField;
    }

    /**
     * Get the screen name
     * 
     * @return the screen name
     */
    public String getScreenName() {
        return screenName;
    }
    
    /**
     * Set the screen name
     * 
     * @param screenName
     *            the screen name
     */
    public void setScreenName( String screenName ) {
        this.screenName = screenName;
    }

    /**
     * Get the type
     * 
     * @return the type
     */
    public FieldTypeEnum getType() {
        return type;
    }

    /**
     * Set the type
     * 
     * @param type
     *            the type
     */
    public void setType( FieldTypeEnum type ) {
        this.type = type;
    }

    /**
     * Get the label
     * 
     * @return the label
     */
    public String getLabel() {
        return label;
    }

    /**
     * Set the label
     * 
     * @param label
     *            the label
     */
    public void setLabel( String label ) {
        this.label = label;
    }

    /**
     * Get the default value
     * 
     * @return the default value
     */
    public String getDefaultValue() {
        return defaultValue;
    }

    /**
     * Set the default value
     * 
     * @param defaultValue
     *            the default value
     */
    public void setDefaultValue( String defaultValue ) {
        this.defaultValue = defaultValue;
    }

    /**
     * Get the order
     * 
     * @return the order
     */
    public Integer getOrder() {
        return order;
    }

    /**
     * Set the order
     * 
     * @param order
     *            the order
     */
    public void setOrder( Integer order ) {
        this.order = order;
    }

    /**
     * Indicates if the field is required or not
     * 
     * @return true if it is required, false otherwise
     */
    public Boolean isRequired() {
        return required;
    }

    /**
     * Set if the field is required or not
     * 
     * @param required
     *            true if it is required, false otherwise
     */
    public void setRequired( Boolean required ) {
        this.required = required;
    }

    /**
     * Indicates if the field is a dropdown or not
     * 
     * @return true if it is a dropdown, false otherwise
     */
    public Boolean isDropDown() {
        return isDropDown;
    }

    /**
     * Set if the field is a dropdown or not
     * 
     * @param required
     *            true if it is a dropdown, false otherwise
     */
    public void setDropDown( Boolean isDropDown ) {
        this.isDropDown = isDropDown;
    }

    /**
     * Get the minimum chars used for validation
     * 
     * @return the minimum chars
     */
    public Integer getMinChars() {
        return minChars;
    }

    /**
     * Set the minimum chars used for validation
     * 
     * @param minChars
     *            the minimum chars
     */
    public void setMinChars( Integer minChars ) {
        this.minChars = minChars;
    }

    /**
     * Get the maximum chars used for validation
     * 
     * @return the maximum chars
     */
    public Integer getMaxChars() {
        return maxChars;
    }

    /**
     * Set the maximum chars used for validation
     * 
     * @param maxChars
     *            the maximum chars
     */
    public void setMaxChars( Integer maxChars ) {
        this.maxChars = maxChars;
    }

    /**
     * @param keyNames the keyNames to set
     */
    public void setKeyNames(Set<UiKeyName> keyNames) {
        this.keyNames = keyNames;
    }

    /**
     * @return the keyNames
     */
    public Set<UiKeyName> getKeyNames() {
        return keyNames;
    }

}