package com.ericsson.cms.contractmgmt.client.model;

import java.util.ArrayList;
import java.util.Collection;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Result object which contains the Copyright Holders (could be a subset) and the total number of Copyright Holders in the
 * system.
 * 
 * @author Gunnar Maluf
 * 
 */
public class ContactSearchResult implements IsSerializable {

    private Collection<UiContact> contactList;
    private int totalCount;
    
    public ContactSearchResult() {
    }

    public ContactSearchResult( Collection<UiContact> lists, int totalCount ) {
        this.contactList = lists;
        if ( this.contactList == null ) {
            this.contactList = new ArrayList<UiContact>();
        }
        this.totalCount = totalCount;
    }

    /**
     * @return the licenses
     */
    public Collection<UiContact> getUiContactList() {
        return contactList;
    }

    /**
     * @return the totalCount
     */
    public int getTotalCount() {
        return totalCount;
    }

}
