package com.ericsson.cms.contractmgmt.client.model;

import java.util.ArrayList;
import java.util.Collection;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Result object which contains the Contracts (could be a subset) and the total number of contracts in the
 * system.
 * 
 * @author Gunnar Maluf
 * 
 */
public class ContractSearchResult implements IsSerializable {

    private Collection<UiContract> contractList;
    private int totalCount;
    
    public ContractSearchResult() {
    }

    public ContractSearchResult( Collection<UiContract> lists, int totalCount ) {
        this.contractList = lists;
        if ( this.contractList == null ) {
            this.contractList = new ArrayList<UiContract>();
        }
        this.totalCount = totalCount;
    }

    /**
     * @return the licenses
     */
    public Collection<UiContract> getUiContractList() {
        return contractList;
    }

    /**
     * @return the totalCount
     */
    public int getTotalCount() {
        return totalCount;
    }

}
