package com.ericsson.cms.contractmgmt.client.model;

import java.util.ArrayList;
import java.util.Collection;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Result object which contains the Copyright Holders (could be a subset) and the total number of Copyright Holders in the
 * system.
 * 
 * @author Gunnar Maluf
 * 
 */
public class CopyrightHolderSearchResult implements IsSerializable {

    private Collection<UiCopyrightHolder> copyrightHolderList;
    private int totalCount;
    
    public CopyrightHolderSearchResult() {
    }

    public CopyrightHolderSearchResult( Collection<UiCopyrightHolder> lists, int totalCount ) {
        this.copyrightHolderList = lists;
        if ( this.copyrightHolderList == null ) {
            this.copyrightHolderList = new ArrayList<UiCopyrightHolder>();
        }
        this.totalCount = totalCount;
    }

    /**
     * @return the licenses
     */
    public Collection<UiCopyrightHolder> getUiCopyrightHolderList() {
        return copyrightHolderList;
    }

    /**
     * @return the totalCount
     */
    public int getTotalCount() {
        return totalCount;
    }

}
