package com.ericsson.cms.contractmgmt.client.model;

import java.util.ArrayList;
import java.util.Collection;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Result object which contains the Deals (could be a subset) and the total number of deals in the
 * system.
 * 
 * @author Gunnar Maluf
 * 
 */
public class DealSearchResult implements IsSerializable {

    private Collection<UiDeal> dealList;
    private int totalCount;
    
    public DealSearchResult() {
    }

    public DealSearchResult( Collection<UiDeal> lists, int totalCount ) {
        this.dealList = lists;
        if ( this.dealList == null ) {
            this.dealList = new ArrayList<UiDeal>();
        }
        this.totalCount = totalCount;
    }

    /**
     * @return the licenses
     */
    public Collection<UiDeal> getUiDealList() {
        return dealList;
    }

    /**
     * @return the totalCount
     */
    public int getTotalCount() {
        return totalCount;
    }

}
