package com.ericsson.cms.contractmgmt.client.model;

import java.util.ArrayList;
import java.util.Collection;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Result object which contains the licenses (could be a subset) and the total number of licenses in the
 * system.
 * 
 * @author Daniel Paranhos
 * 
 */
public class LicenseSearchResult implements IsSerializable {

    private Collection<UiLicense> licensesList;
    private int totalCount;
    
    public LicenseSearchResult() {
    }

    public LicenseSearchResult( Collection<UiLicense> lists, int totalCount ) {
        this.licensesList = lists;
        if ( this.licensesList == null ) {
            this.licensesList = new ArrayList<UiLicense>();
        }
        this.totalCount = totalCount;
    }

    /**
     * @return the licenses
     */
    public Collection<UiLicense> getUiLicensesList() {
        return licensesList;
    }

    /**
     * @return the totalCount
     */
    public int getTotalCount() {
        return totalCount;
    }

}
