package com.ericsson.cms.contractmgmt.client.model;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Asset representation for the UI layer.
 * 
 * @author Daniel Paranhos
 */
public class UiAsset implements IsSerializable {
    
    private Long key;
    private String packageAssetId;
    private String name;
    private String providerId;
    
    /**
     * Default constructor
     */
    public UiAsset() {
    }
    
    /**
     * Constructor
     */
    public UiAsset( Long key ) {
        this.key = key;
    }
    
    /**
     * Get the key
     * 
     * @return the key
     */
    public Long getKey() {
        return key;
    }

    /**
     * Set the key
     * 
     * @param key
     *            the key to set
     */
    public void setKey( Long key ) {
        this.key = key;
    }

    /**
     * Get the package asset id
     * 
     * @return the packageAssetId
     */
    public String getPackageAssetId() {
        return packageAssetId;
    }

    /**
     * Set the package asset id
     * 
     * @param packageAssetId
     *            the packageAssetId to set
     */
    public void setPackageAssetId( String packageAssetId ) {
        this.packageAssetId = packageAssetId;
    }
    
    /**
     * Get the name
     * 
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Set the name
     * 
     * @param name
     *            the name to set
     */
    public void setName( String name ) {
        this.name = name;
    }
    
    /**
     * Get the provider id
     * 
     * @return the provider id
     */
    public String getProviderId() {
        return providerId;
    }

    /**
     * Set the provider id
     * 
     * @param providerId
     *            the provider id to set
     */
    public void setProviderId( String providerId ) {
        this.providerId = providerId;
    }

}
