package com.ericsson.cms.contractmgmt.client.model;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Contact representation for the UI layer.
 * 
 * @author Gunnar Maluf
 */
public class UiContact implements IsSerializable {

    private Long key;
    private String name;
    private String email;
    private String phoneOffice;
    private String phoneWork;
    private String phoneMobile;
    private boolean notify;
    
    
    /**
     * Default constructor
     */
    public UiContact() {
    }

    
    public UiContact ( UiContact contact){
        this.key = contact.getKey();
        this.email = contact.getEmail();
        this.name = contact.getName();
        this.notify = contact.isNotify();
        this.phoneMobile = contact.getPhoneMobile();
        this.phoneOffice = contact.getPhoneOffice();
        this.phoneWork = contact.getPhoneWork();
    }
    
    /**
     * Get the contact name
     * 
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Set the contact name
     * 
     * @param name
     *            the name
     */
    public void setName( String name ) {
        this.name = name;
    }

    /**
     * Get the key
     * 
     * @return the key
     */
    public Long getKey() {
        return key;
    }

    /**
     * Set the key
     * 
     * @param key
     *            the key to set
     */
    public void setKey( Long key ) {
        this.key = key;
    }

	/**
	 * @return the email
	 */
	public String getEmail() {
		return email;
	}

	/**
	 * @param email the email to set
	 */
	public void setEmail(String email) {
		this.email = email;
	}

	/**
	 * @return the phoneOffice
	 */
	public String getPhoneOffice() {
		return phoneOffice;
	}

	/**
	 * @param phoneOffice the phoneOffice to set
	 */
	public void setPhoneOffice(String phoneOffice) {
		this.phoneOffice = phoneOffice;
	}

	/**
	 * @return the phoneWork
	 */
	public String getPhoneWork() {
		return phoneWork;
	}

	/**
	 * @param phoneWork the phoneWork to set
	 */
	public void setPhoneWork(String phoneWork) {
		this.phoneWork = phoneWork;
	}

	/**
	 * @return the phoneMobile
	 */
	public String getPhoneMobile() {
		return phoneMobile;
	}

	/**
	 * @param phoneMobile the phoneMobile to set
	 */
	public void setPhoneMobile(String phoneMobile) {
		this.phoneMobile = phoneMobile;
	}

	/**
	 * @return the notify
	 */
	public boolean isNotify() {
		return notify;
	}

	/**
	 * @param notify the notify to set
	 */
	public void setNotify(boolean notify) {
		this.notify = notify;
	}

	

}
