package com.ericsson.cms.contractmgmt.client.model;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Content Provider representation for the UI layer.
 * 
 * @author Daniel Paranhos
 */
public class UiContentProvider implements IsSerializable, Comparable<UiContentProvider> {
    
    private String providerId;

    private String name;

    /**
     * Default constructor
     */
    public UiContentProvider() {
    }
    
    /**
     * Constructor
     */
    public UiContentProvider( String providerId) {
        this.providerId = providerId;
    }
    
    /**
     * Get the provider id
     * 
     * @return the providerId
     */
    public String getProviderId() {
        return providerId;
    }

    /**
     * Set the provider id
     * 
     * @param providerId
     *            the providerId to set
     */
    public void setProviderId( String providerId ) {
        this.providerId = providerId;
    }

    /**
     * Get the name
     * 
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Set the name
     * 
     * @param name
     *            the name to set
     */
    public void setName( String name ) {
        this.name = name;
    }

	@Override
	public int compareTo(UiContentProvider arg0) {
		// Alphabetically sort by the name.
	    return this.name.compareToIgnoreCase( arg0.name );
	}

}
