package com.ericsson.cms.contractmgmt.client.model;

import java.util.Date;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedFieldValue;
import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Contract representation for the UI layer.
 * 
 * @author Daniel Paranhos
 */
public class UiContract implements IsSerializable {

    private Long key;
    private UiCopyrightHolder copyrightHolder;
    private String name;
    private Date creationDate;
    private Date effectiveDate;
    private Date expiryDate;
    private Long dealExpiryReminder;
    private boolean active;
    private UiContractType type;
    private List<UiDocument> uiDocumentList;
    private List<UiContact> uiContactList;
    private List<UiDeal> uiDealsList;
    private List<UiUserDefinedFieldValue> userDefinedFieldsValues;
    private String externalId;

    /**
     * Default constructor
     */
    public UiContract() {
        this.copyrightHolder = new UiCopyrightHolder();
    }

    /**
     * Constructor
     * 
     * @param key
     *            the key
     */
    public UiContract( Long key ) {
        this.key = key;
        this.copyrightHolder = new UiCopyrightHolder();
    }
    
    /**
     * Get the contract name
     * 
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Set the contract name
     * 
     * @param name
     *            the name
     */
    public void setName( String name ) {
        this.name = name;
    }

    /**
     * Get the key
     * 
     * @return the key
     */
    public Long getKey() {
        return key;
    }

    /**
     * Set the key
     * 
     * @param key
     *            the key to set
     */
    public void setKey( Long key ) {
        this.key = key;
    }

    /**
     * Get the copyright holder
     * 
     * @return the copyright holder
     */
    public UiCopyrightHolder getCopyrightHolder() {
        return copyrightHolder;
    }

    /**
     * Set the copyright holder
     * 
     * @param copyrightHolder
     *            the copyright holder to set
     */
    public void setCopyrightHolder( UiCopyrightHolder copyrightHolder ) {
        this.copyrightHolder = copyrightHolder;
    }

    /**
     * @return the creationDate
     */
    public Date getCreationDate() {
        return creationDate;
    }

    /**
     * @param creationDate
     *            the creationDate to set
     */
    public void setCreationDate( Date creationDate ) {
        this.creationDate = creationDate;
    }

    /**
     * @return the effectiveDate
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * @param effectiveDate
     *            the effectiveDate to set
     */
    public void setEffectiveDate( Date effectiveDate ) {
        this.effectiveDate = effectiveDate;
    }

    /**
     * @return the expiryDate
     */
    public Date getExpiryDate() {
        return expiryDate;
    }

    /**
     * @param expiryDate
     *            the expiryDate to set
     */
    public void setExpiryDate( Date expiryDate ) {
        this.expiryDate = expiryDate;
    }

    /**
     * @return the dealExpiryReminder
     */
    public Long getDealExpiryReminder() {
        return dealExpiryReminder;
    }

    /**
     * @param dealExpiryReminder
     *            the dealExpiryReminder to set
     */
    public void setDealExpiryReminder( Long dealExpiryReminder ) {
        this.dealExpiryReminder = dealExpiryReminder;
    }

    /**
     * @return the active
     */
    public boolean isActive() {
        return active;
    }

    /**
     * @param active
     *            the active to set
     */
    public void setActive( boolean active ) {
        this.active = active;
    }

    /**
     * @return the type
     */
    public UiContractType getType() {
        return type;
    }

    /**
     * @param type
     *            the type to set
     */
    public void setType( UiContractType type ) {
        this.type = type;
    }

    /**
     * @return the uiDocumentList
     */
    public List<UiDocument> getUiDocumentList() {
        return uiDocumentList;
    }

    /**
     * @param uiDocumentList
     *            the uiDocumentList to set
     */
    public void setUiDocumentList( List<UiDocument> uiDocumentList ) {
        this.uiDocumentList = uiDocumentList;
    }

    /**
     * @return the uiContactList
     */
    public List<UiContact> getUiContactList() {
        return uiContactList;
    }

    /**
     * @param uiContactList
     *            the uiContactList to set
     */
    public void setUiContactList( List<UiContact> uiContactList ) {
        this.uiContactList = uiContactList;
    }

	/**
	 * @return the userDefinedFieldsValues
	 */
	public List<UiUserDefinedFieldValue> getUserDefinedFieldsValues() {
		return userDefinedFieldsValues;
	}

	/**
	 * @param userDefinedFieldsValues the userDefinedFieldsValues to set
	 */
	public void setUserDefinedFieldsValues(List<UiUserDefinedFieldValue> userDefinedFieldsValues) {
		this.userDefinedFieldsValues = userDefinedFieldsValues;
	}

	/**
	 * @return the uiDealsList
	 */
	public List<UiDeal> getUiDealsList() {
		return uiDealsList;
	}

	/**
	 * @param uiDealsList the uiDealsList to set
	 */
	public void setUiDealsList(List<UiDeal> uiDealsList) {
		this.uiDealsList = uiDealsList;
	}

	/**
	 * @return the externalId
	 */
	public String getExternalId() {
		return externalId;
	}

	/**
	 * @param externalId the externalId to set
	 */
	public void setExternalId(String externalId) {
		this.externalId = externalId;
	}
}
