package com.ericsson.cms.contractmgmt.client.model;

import java.util.List;

import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedFieldValue;
import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * CopyrightHolder representation for the UI layer.
 * 
 * @author Daniel Paranhos
 */
public class UiCopyrightHolder implements IsSerializable {

    private Long key;
    private String name;
    private String address;
    private String affiliation;
    private List<UiDocument> uiDocumentList;
    private List<UiContact> uiContactList;
    private List<UiContract> uiContractList;
    private List<UiUserDefinedFieldValue> userDefinedFieldsValues;
    private String externalId;

    /**
     * Default constructor
     */
    public UiCopyrightHolder() {
    }

    /**
     * Constructor
     * 
     * @param key
     *            the key
     */
    public UiCopyrightHolder( Long key ) {
        this.key = key;
    }

    
    /**
     * Get the copyright holder name
     * 
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Set the copyright holder name
     * 
     * @param name
     *            the name
     */
    public void setName( String name ) {
        this.name = name;
    }

    /**
     * Get the key
     * 
     * @return the key
     */
    public Long getKey() {
        return key;
    }

    /**
     * Set the key
     * 
     * @param key
     *            the key to set
     */
    public void setKey( Long key ) {
        this.key = key;
    }

    /**
     * @return the address
     */
    public String getAddress() {
        return address;
    }

    /**
     * @param address
     *            the address to set
     */
    public void setAddress( String address ) {
        this.address = address;
    }

    /**
     * @return the affiliation
     */
    public String getAffiliation() {
        return affiliation;
    }

    /**
     * @param affiliation
     *            the affiliation to set
     */
    public void setAffiliation( String affiliation ) {
        this.affiliation = affiliation;
    }

    /**
     * @return the uiDocumentList
     */
    public List<UiDocument> getUiDocumentList() {
        return uiDocumentList;
    }

    /**
     * @param uiDocumentList
     *            the uiDocumentList to set
     */
    public void setUiDocumentList( List<UiDocument> uiDocumentList ) {
        this.uiDocumentList = uiDocumentList;
    }

    /**
     * @return the uiContactList
     */
    public List<UiContact> getUiContactList() {
        return uiContactList;
    }

    /**
     * @param uiContactList
     *            the uiContactList to set
     */
    public void setUiContactList( List<UiContact> uiContactList ) {
        this.uiContactList = uiContactList;
    }

	/**
	 * @return the userDefinedFieldsValues
	 */
	public List<UiUserDefinedFieldValue> getUserDefinedFieldsValues() {
		return userDefinedFieldsValues;
	}

	/**
	 * @param userDefinedFieldsValues the userDefinedFieldsValues to set
	 */
	public void setUserDefinedFieldsValues(List<UiUserDefinedFieldValue> userDefinedFieldsValues) {
		this.userDefinedFieldsValues = userDefinedFieldsValues;
	}

	/**
	 * @return the uiContractList
	 */
	public List<UiContract> getUiContractList() {
		return uiContractList;
	}

	/**
	 * @param uiContractList the uiContractList to set
	 */
	public void setUiContractList(List<UiContract> uiContractList) {
		this.uiContractList = uiContractList;
	}

	/**
	 * @return the externalId
	 */
	public String getExternalId() {
		return externalId;
	}

	/**
	 * @param externalId the externalId to set
	 */
	public void setExternalId(String externalId) {
		this.externalId = externalId;
	}

}
