package com.ericsson.cms.contractmgmt.client.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedFieldValue;
import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Deal representation for the UI layer.
 * 
 * @author Daniel Paranhos
 */
public class UiDeal implements IsSerializable {

    private Long key;
    private UiContract contract;
    private String name;
    private UiDealType type;
    private boolean active;
    private Date creationDate;
    private Date effectiveDate;
    private Date expiryDate;
    private Long licenseExpiryReminder;
    private List<UiContact> uiContactList;
    private List<UiDocument> uiDocumentList;
    private List<UiLicense> uiLicenseList;
    private List<UiUserDefinedFieldValue> userDefinedFieldsValues;
    private String externalId;

    /**
     * Default constructor
     */
    public UiDeal() {
        this.contract = new UiContract();
        this.uiContactList = new ArrayList<UiContact>();
        this.uiDocumentList = new ArrayList<UiDocument>();
        this.uiLicenseList = new ArrayList<UiLicense>();
        this.userDefinedFieldsValues = new ArrayList<UiUserDefinedFieldValue>();
    }

    /**
     * Constructor
     * 
     * @param key
     *            the key
     */
    public UiDeal( Long key ) {
        this();
        this.key = key;
    }

    /**
     * Get the deal name
     * 
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Set the deal name
     * 
     * @param name
     *            the name
     */
    public void setName( String name ) {
        this.name = name;
    }

    /**
     * Get the key
     * 
     * @return the key
     */
    public Long getKey() {
        return key;
    }

    /**
     * Set the key
     * 
     * @param key
     *            the key to set
     */
    public void setKey( Long key ) {
        this.key = key;
    }

    /**
     * Get the contract
     * 
     * @return the contract
     */
    public UiContract getContract() {
        return contract;
    }

    /**
     * Set the contract
     * 
     * @param contract
     *            the contract to set
     */
    public void setContract( UiContract contract ) {
        this.contract = contract;
    }

    /**
     * @return the type
     */
    public UiDealType getType() {
        return type;
    }

    /**
     * @param type
     *            the type to set
     */
    public void setType( UiDealType type ) {
        this.type = type;
    }

    /**
     * @return the active
     */
    public boolean isActive() {
        return active;
    }

    /**
     * @param active
     *            the active to set
     */
    public void setActive( boolean active ) {
        this.active = active;
    }

    /**
     * @return the creationDate
     */
    public Date getCreationDate() {
        return creationDate;
    }

    /**
     * @param creationDate
     *            the creationDate to set
     */
    public void setCreationDate( Date creationDate ) {
        this.creationDate = creationDate;
    }

    /**
     * @return the effectiveDate
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * @param effectiveDate
     *            the effectiveDate to set
     */
    public void setEffectiveDate( Date effectiveDate ) {
        this.effectiveDate = effectiveDate;
    }

    /**
     * @return the expiryDate
     */
    public Date getExpiryDate() {
        return expiryDate;
    }

    /**
     * @param expiryDate
     *            the expiryDate to set
     */
    public void setExpiryDate( Date expiryDate ) {
        this.expiryDate = expiryDate;
    }

    /**
     * @return the licenseExpiryReminder
     */
    public Long getLicenseExpiryReminder() {
        return licenseExpiryReminder;
    }

    /**
     * @param licenseExpiryReminder
     *            the licenseExpiryReminder to set
     */
    public void setLicenseExpiryReminder( Long licenseExpiryReminder ) {
        this.licenseExpiryReminder = licenseExpiryReminder;
    }

    /**
     * @return the uiContactList
     */
    public List<UiContact> getUiContactList() {
        return uiContactList;
    }

    /**
     * @param uiContactList
     *            the uiContactList to set
     */
    public void setUiContactList( List<UiContact> uiContactList ) {
        this.uiContactList = uiContactList;
    }

    /**
     * @return the uiDocumentList
     */
    public List<UiDocument> getUiDocumentList() {
        return uiDocumentList;
    }

    /**
     * @param uiDocumentList
     *            the uiDocumentList to set
     */
    public void setUiDocumentList( List<UiDocument> uiDocumentList ) {
        this.uiDocumentList = uiDocumentList;
    }

    /**
     * @return the uiLicenseList
     */
    public List<UiLicense> getUiLicenseList() {
        return uiLicenseList;
    }

    /**
     * @param uiLicenseList
     *            the uiLicenseList to set
     */
    public void setUiLicenseList( List<UiLicense> uiLicenseList ) {
        this.uiLicenseList = uiLicenseList;
    }

	/**
	 * @return the userDefinedFieldsValues
	 */
	public List<UiUserDefinedFieldValue> getUserDefinedFieldsValues() {
		return userDefinedFieldsValues;
	}

	/**
	 * @param userDefinedFieldsValues the userDefinedFieldsValues to set
	 */
	public void setUserDefinedFieldsValues(List<UiUserDefinedFieldValue> userDefinedFieldsValues) {
		this.userDefinedFieldsValues = userDefinedFieldsValues;
	}

	/**
	 * @return the externalId
	 */
	public String getExternalId() {
		return externalId;
	}

	/**
	 * @param externalId the externalId to set
	 */
	public void setExternalId(String externalId) {
		this.externalId = externalId;
	}
}
