package com.ericsson.cms.contractmgmt.client.model;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.HasName;

/**
 * Device representation for the UI layer.
 * 
 * @author Daniel Paranhos
 */
public class UiDevice implements IsSerializable, HasName {

    private Long key;
    private String name;
    private UiPlatform platform;

    /**
     * Default constructor
     */
    public UiDevice() {
        this.platform = new UiPlatform();
    }

    /**
     * Constructor
     */
    public UiDevice( Long key ) {
        this();
        this.key = key;
    }

    /**
     * Get the key
     * 
     * @return the key
     */
    public Long getKey() {
        return key;
    }

    /**
     * Set the key
     * 
     * @param key
     *            the key to set
     */
    public void setKey( Long key ) {
        this.key = key;
    }

    /**
     * Get the name
     * 
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Set the name
     * 
     * @param name
     *            the name to set
     */
    public void setName( String name ) {
        this.name = name;
    }

    /**
     * Get the platform
     * 
     * @return the platform
     */
    public UiPlatform getPlatform() {
        return platform;
    }

    /**
     * Set the platform
     * 
     * @param platform
     *            the platform to set
     */
    public void setPlatform( UiPlatform platform ) {
        this.platform = platform;
    }

}
