package com.ericsson.cms.contractmgmt.client.model;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Collection of devices with the total count
 * 
 * @author Daniel Paranhos
 * 
 */
public class UiDevices implements IsSerializable {

    private List<UiDevice> devices;
    private int totalCount;

    /**
     * Default constructor
     */
    public UiDevices() {
        if ( this.devices == null ) {
            this.devices = new ArrayList<UiDevice>();
        }
    }

    /**
     * Constructor
     * 
     * @param devices
     *            the list of devices, not necessarily all devices present in database if pagination is being
     *            used
     * @param totalCount
     *            the total count of devices present in database
     */
    public UiDevices( List<UiDevice> devices, int totalCount ) {
        super();
        this.devices = devices;
        if ( this.devices == null ) {
            this.devices = new ArrayList<UiDevice>();
        }
        this.totalCount = totalCount;
    }

    /**
     * Get the list of devices
     * 
     * @return the devices
     */
    public List<UiDevice> getDevices() {
        return devices;
    }

    /**
     * Set the total count of devices present in database
     * 
     * @return the total count
     */
    public int getTotalCount() {
        return totalCount;
    }
}
