package com.ericsson.cms.contractmgmt.client.model;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Collection of key names with the total count
 * 
 * @author Daniel Paranhos
 * 
 */
public class UiKeyNames implements IsSerializable {

    private List<UiKeyName> keyNames;
    private int totalCount;

    /**
     * Default constructor
     */
    public UiKeyNames() {
        this.keyNames = new ArrayList<UiKeyName>();
    }

    /**
     * Constructor
     * 
     * @param keyNames
     *            the list of records, not necessarily all records present in database if pagination is
     *            being used
     * @param totalCount
     *            the total count of records present in database
     */
    public UiKeyNames( List<UiKeyName> keyNames, int totalCount ) {
        this();
        
        if ( keyNames != null ) {
            this.keyNames.addAll( keyNames );
        }
        this.totalCount = totalCount;
    }

    /**
     * Get the list of records
     * 
     * @return the records
     */
    public List<UiKeyName> getRecords() {
        return keyNames;
    }

    /**
     * Get the total count of records present in database
     * 
     * @return the total count
     */
    public int getTotalCount() {
        return totalCount;
    }

    /**
     * Set the total count of records present in database
     * 
     * @param totalCount the totalCount to set
     */
    public void setTotalCount( int totalCount ) {
        this.totalCount = totalCount;
    }
}
