package com.ericsson.cms.contractmgmt.client.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldFactory;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedFieldValue;
import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * License representation for the UI layer.
 * 
 * @author Daniel Paranhos
 */
public class UiLicense implements IsSerializable {

    private Long key;
    private UiDeal deal;
    private String name;
    private UiKeyName type;
    private boolean active;
    private Date creationDate;
    private Date effectiveDate;
    private Date expiryDate;
    private String notes;
    private UiContentProvider contentProvider;
    private List<UiUserDefinedField> userDefinedFields;
    private List<UiUserDefinedFieldValue> userDefinedFieldsValues;
    private List<UiDeliveryLocation> deliveryLocations;
    private List<UiPlatform> platforms;
    private List<UiDevice> devices;
    private List<UiLicenseDetails> licenseDetailsList;
    private List<UiDocument> documentsList;
    private Boolean allAssets;
    private List<UiAsset> assetList;
    private String externalId;

    /**
     * Default constructor
     */
    public UiLicense() {
        this.allAssets = Boolean.TRUE;
        this.active = true;
        this.deal = new UiDeal();
        this.type = new UiKeyName();
        this.contentProvider = new UiContentProvider();
        this.userDefinedFields = new ArrayList<UiUserDefinedField>();
        this.userDefinedFieldsValues = new ArrayList<UiUserDefinedFieldValue>();
        this.deliveryLocations = new ArrayList<UiDeliveryLocation>();
        this.platforms = new ArrayList<UiPlatform>();
        this.devices = new ArrayList<UiDevice>();
        this.licenseDetailsList = new ArrayList<UiLicenseDetails>();
        this.documentsList = new ArrayList<UiDocument>();
        this.assetList = new ArrayList<UiAsset>();
    }

    /**
     * Get the deal name
     * 
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Set the deal name
     * 
     * @param name
     *            the name
     */
    public void setName( String name ) {
        this.name = name;
    }

    /**
     * Get the key
     * 
     * @return the key
     */
    public Long getKey() {
        return key;
    }

    /**
     * Set the key
     * 
     * @param key
     *            the key to set
     */
    public void setKey( Long key ) {
        this.key = key;
    }

    /**
     * Get the deal
     * 
     * @return the deal
     */
    public UiDeal getDeal() {
        return deal;
    }

    /**
     * Set the deal
     * 
     * @param deal
     *            the deal to set
     */
    public void setDeal( UiDeal deal ) {
        this.deal = deal;
    }

    /**
     * Get the type
     * 
     * @return the type
     */
    public UiKeyName getType() {
        return type;
    }

    /**
     * Set the type
     * 
     * @param type
     *            the type to set
     */
    public void setType( UiKeyName type ) {
        this.type = type;
    }

    /**
     * Checks if the license is active or not
     * 
     * @return true if it is active, false otherwise
     */
    public boolean isActive() {
        return active;
    }

    /**
     * Sets if the license is active or not
     * 
     * @param active
     *            true if it is active, false otherwise
     */
    public void setActive( boolean active ) {
        this.active = active;
    }

    /**
     * Get the creation date
     * 
     * @return the creation date
     */
    public Date getCreationDate() {
        return creationDate;
    }

    /**
     * Set the creation date
     * 
     * @param creationDate
     *            the creation date to set
     */
    public void setCreationDate( Date creationDate ) {
        this.creationDate = creationDate;
    }

    /**
     * Get the effective date
     * 
     * @return the effective date
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * Set the effective date
     * 
     * @param effectiveDate
     *            the effective date to set
     */
    public void setEffectiveDate( Date effectiveDate ) {
        this.effectiveDate = effectiveDate;
    }

    /**
     * Get the expiry date
     * 
     * @return the expiry date
     */
    public Date getExpiryDate() {
        return expiryDate;
    }

    /**
     * Set the expiry date
     * 
     * @param expiryDate
     *            the expiry date to set
     */
    public void setExpiryDate( Date expiryDate ) {
        this.expiryDate = expiryDate;
    }

    /**
     * Get the notes
     * 
     * @return the notes
     */
    public String getNotes() {
        return notes;
    }

    /**
     * Set the notes
     * 
     * @param notes
     *            the notes to set
     */
    public void setNotes( String notes ) {
        this.notes = notes;
    }

    /**
     * Get the content provider
     * 
     * @return the contentProvider
     */
    public UiContentProvider getContentProvider() {
        return contentProvider;
    }

    /**
     * Set the content provider
     * 
     * @param contentProvider
     *            the contentProvider to set
     */
    public void setContentProvider( UiContentProvider contentProvider ) {
        this.contentProvider = contentProvider;
    }

    /**
     * Get the list of user defined fields
     * 
     * @return the list of user defined fields
     */
    public List<UiUserDefinedField> getUserDefinedFields() {
        return userDefinedFields;
    }

    /**
     * Get the list of user defined fields for a given screen name
     * 
     * @param screenName
     *            the screen name
     * @return the list of user defined fields
     */
    public List<UiUserDefinedField> getUserDefinedFields( String screenName ) {
        List<UiUserDefinedField> filteredUserDefinedFieldValues = new ArrayList<UiUserDefinedField>();
        for ( UiUserDefinedField field : userDefinedFields ) {
            if ( field.getScreenName().equals( screenName ) ) {
                filteredUserDefinedFieldValues.add( field );
            }
        }
        return filteredUserDefinedFieldValues;
    }

    /**
     * Get the list of user defined field values
     * 
     * @return the list of user defined field values
     */
    public List<UiUserDefinedFieldValue> getUserDefinedFieldsValues() {
        return userDefinedFieldsValues;
    }

    /**
     * Get the list of delivery locations
     * 
     * @return the list of delivery locations
     */
    public List<UiDeliveryLocation> getDeliveryLocations() {
        return deliveryLocations;
    }

    /**
     * Get the list of platforms
     * 
     * @return the list of platforms
     */
    public List<UiPlatform> getPlatforms() {
        return platforms;
    }

    /**
     * Get the list of devices
     * 
     * @return the list of devices
     */
    public List<UiDevice> getDevices() {
        return devices;
    }

    /**
     * Get the list of license details
     * 
     * @return the list of license details
     */
    public List<UiLicenseDetails> getLicenseDetailsList() {
        return licenseDetailsList;
    }

    /**
     * Get the default license details
     * 
     * @return the default license details
     */
    public UiLicenseDetails getDefaultLicenseDetails() {
        UiLicenseDetails licenseDetails = null;
        for ( UiLicenseDetails ld : licenseDetailsList ) {
            if ( ld.getDeliveryLocation() == null ) {
                licenseDetails = ld;
                break;
            }
        }

        return licenseDetails;
    }

    public List<UiDocument> getDocumentsList() {
        return documentsList;
    }

    public Boolean getAllAssets() {
        return allAssets;
    }

    public void setAllAssets( Boolean allAssets ) {
        this.allAssets = allAssets;
    }

    public List<UiAsset> getAssetList() {
        return assetList;
    }

    /**
     * Reset the user defined field values for the license and license details objects
     */
    public void resetDefaultValues() {
        this.userDefinedFieldsValues.clear();
        UiLicenseDetails defaultLicenseDetails = getDefaultLicenseDetails();
        if ( defaultLicenseDetails != null ) {
            defaultLicenseDetails.getUserDefinedFieldValues().clear();
            for ( UiUserDefinedField field : getUserDefinedFields( CustomFieldFactory.LICENSE_SCREEN ) ) {
                this.userDefinedFieldsValues.add( createUserDefinedFieldValue( field ) );
            }
        }

        for ( UiLicenseDetails licenseDetails : licenseDetailsList ) {
            licenseDetails.resetUserDefinedFieldValues();
        }
    }

    private UiUserDefinedFieldValue createUserDefinedFieldValue( UiUserDefinedField field ) {
        UiUserDefinedFieldValue value = new UiUserDefinedFieldValue();
        value.setIdUserDefinedField( field.getIdUserDefinedField() );
        value.setValue( field.getDefaultValue() );
        return value;
    }

	/**
	 * @return the externalId
	 */
	public String getExternalId() {
		return externalId;
	}

	/**
	 * @param externalId the externalId to set
	 */
	public void setExternalId(String externalId) {
		this.externalId = externalId;
	}

	public void setDocumentsList(List<UiDocument> documentsList) {
		this.documentsList = documentsList;
	}
}
