package com.ericsson.cms.contractmgmt.client.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldFactory;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedFieldValue;
import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * License Details representation for the UI layer.
 * 
 * @author Daniel Paranhos
 */
public class UiLicenseDetails implements IsSerializable {

    private Long key;
    private UiLicense license;
    private UiDeliveryLocation deliveryLocation;
    private UiPlatform platform;
    private UiDevice device;
    private Boolean smPosterArtRequired;
    private Boolean smPreviewRequired;
    private Date smEffectiveDate;
    private Date smExpiryDate;
    private Boolean aeWaterMarking;
    private Boolean aeFingerPrinting;
    private Boolean aeTranscoding;
    private Boolean aeAdRemoval;
    private Boolean aeContentEdit;
    private Boolean aeQualityCheck;
    private Boolean aeContentSecurity;
    private Long prGuaranteedSubscribers;
    private String prGuaranteedBuyRate;
    private String prDeemedRetailPrice;
    private String prActualRetailPrice;
    private String prLostBuys;
    private String prRevenueShare;
    private String prActualLicenseFee;
    private String prMinimumLicenseFee;
    private Boolean prUpfrontPaymentRequired;
    private String prUpfrontPayment;
    private Boolean prOverageRequired;
    private String prOverage;
    private Boolean prInstallmentPlanRequired;
    private String prInstallmentPlan;
    private Boolean prTieredPricingRequired;
    private Boolean prRevenueShareRequired;
    private UiCurrency prCurrency;
    private Boolean modified;

    private List<UiUserDefinedFieldValue> userDefinedFieldsValues;

    private List<UiDistributionManagement> distributionManagementList;
    private List<UiLanguage> languageList;
    private List<UiRevenuePricing> revenueSharedList;
    private List<UiRevenuePricing> tieredPricingList;

    private List<UiLicenseDetails> children;

    /**
     * Default constructor
     */
    public UiLicenseDetails() {
        this.aeAdRemoval = Boolean.FALSE;
        this.aeContentEdit = Boolean.FALSE;
        this.aeContentSecurity = Boolean.FALSE;
        this.aeFingerPrinting = Boolean.FALSE;
        this.aeQualityCheck = Boolean.FALSE;
        this.aeTranscoding = Boolean.FALSE;
        this.aeWaterMarking = Boolean.FALSE;
        this.smPosterArtRequired = Boolean.FALSE;
        this.smPreviewRequired = Boolean.FALSE;
        this.prOverageRequired = Boolean.FALSE;
        this.prInstallmentPlanRequired = Boolean.FALSE;
        this.prTieredPricingRequired = Boolean.FALSE;
        this.prRevenueShareRequired = Boolean.FALSE;
        this.modified = Boolean.FALSE;
        this.distributionManagementList = new ArrayList<UiDistributionManagement>();
        this.languageList = new ArrayList<UiLanguage>();
        this.userDefinedFieldsValues = new ArrayList<UiUserDefinedFieldValue>();
        this.revenueSharedList = new ArrayList<UiRevenuePricing>();
        this.tieredPricingList = new ArrayList<UiRevenuePricing>();
        this.children = new ArrayList<UiLicenseDetails>();
        this.license = new UiLicense();
    }

    /**
     * Constructor
     * 
     * @param license
     *            the license
     */
    public UiLicenseDetails( UiLicense license ) {
        this();
        this.license = license;

        resetUserDefinedFieldValues();
    }

    /**
     * Get the key
     * 
     * @return the key
     */
    public Long getKey() {
        return key;
    }

    /**
     * Set the key
     * 
     * @param key
     *            the key to set
     */
    public void setKey( Long key ) {
        this.key = key;
    }

    public UiLicense getLicense() {
        return license;
    }

    public void setLicense( UiLicense license ) {
        this.license = license;
    }

    public UiDeliveryLocation getDeliveryLocation() {
        return deliveryLocation;
    }

    public void setDeliveryLocation( UiDeliveryLocation deliveryLocation ) {
        this.deliveryLocation = deliveryLocation;
    }

    public UiPlatform getPlatform() {
        return platform;
    }

    public void setPlatform( UiPlatform platform ) {
        this.platform = platform;
    }

    public UiDevice getDevice() {
        return device;
    }

    public void setDevice( UiDevice device ) {
        this.device = device;
    }

    public Boolean getSmPosterArtRequired() {
        return smPosterArtRequired;
    }

    public void setSmPosterArtRequired( Boolean smPosterArtRequired ) {
        this.smPosterArtRequired = smPosterArtRequired;
    }

    public Boolean getSmPreviewRequired() {
        return smPreviewRequired;
    }

    public void setSmPreviewRequired( Boolean smPreviewRequired ) {
        this.smPreviewRequired = smPreviewRequired;
    }

    public Date getSmEffectiveDate() {
        return smEffectiveDate;
    }

    public void setSmEffectiveDate( Date smEffectiveDate ) {
        this.smEffectiveDate = smEffectiveDate;
    }

    public Date getSmExpiryDate() {
        return smExpiryDate;
    }

    public void setSmExpiryDate( Date smExpiryDate ) {
        this.smExpiryDate = smExpiryDate;
    }

    public Boolean getAeWaterMarking() {
        return aeWaterMarking;
    }

    public void setAeWaterMarking( Boolean aeWaterMarking ) {
        this.aeWaterMarking = aeWaterMarking;
    }

    public Boolean getAeFingerPrinting() {
        return aeFingerPrinting;
    }

    public void setAeFingerPrinting( Boolean aeFingerPrinting ) {
        this.aeFingerPrinting = aeFingerPrinting;
    }

    public Boolean getAeTranscoding() {
        return aeTranscoding;
    }

    public void setAeTranscoding( Boolean aeTranscoding ) {
        this.aeTranscoding = aeTranscoding;
    }

    public Boolean getAeAdRemoval() {
        return aeAdRemoval;
    }

    public void setAeAdRemoval( Boolean aeAdRemoval ) {
        this.aeAdRemoval = aeAdRemoval;
    }

    public Boolean getAeContentEdit() {
        return aeContentEdit;
    }

    public void setAeContentEdit( Boolean aeContentEdit ) {
        this.aeContentEdit = aeContentEdit;
    }

    public Boolean getAeQualityCheck() {
        return aeQualityCheck;
    }

    public void setAeQualityCheck( Boolean aeQualityCheck ) {
        this.aeQualityCheck = aeQualityCheck;
    }

    public Boolean getAeContentSecurity() {
        return aeContentSecurity;
    }

    public void setAeContentSecurity( Boolean aeContentSecurity ) {
        this.aeContentSecurity = aeContentSecurity;
    }

    public Long getPrGuaranteedSubscribers() {
        return prGuaranteedSubscribers;
    }

    public void setPrGuaranteedSubscribers( Long prGuaranteedSubscribers ) {
        this.prGuaranteedSubscribers = prGuaranteedSubscribers;
    }

    public String getPrGuaranteedBuyRate() {
        return prGuaranteedBuyRate;
    }

    public void setPrGuaranteedBuyRate( String prGuaranteedBuyRate ) {
        this.prGuaranteedBuyRate = prGuaranteedBuyRate;
    }

    public String getPrDeemedRetailPrice() {
        return prDeemedRetailPrice;
    }

    public void setPrDeemedRetailPrice( String prDeemedRetailPrice ) {
        this.prDeemedRetailPrice = prDeemedRetailPrice;
    }

    public String getPrActualRetailPrice() {
        return prActualRetailPrice;
    }

    public void setPrActualRetailPrice( String prActualRetailPrice ) {
        this.prActualRetailPrice = prActualRetailPrice;
    }

    public String getPrLostBuys() {
        return prLostBuys;
    }

    public void setPrLostBuys( String prLostBuys ) {
        this.prLostBuys = prLostBuys;
    }

    public String getPrRevenueShare() {
        return prRevenueShare;
    }

    public void setPrRevenueShare( String prRevenueShare ) {
        this.prRevenueShare = prRevenueShare;
    }

    public String getPrActualLicenseFee() {
        return prActualLicenseFee;
    }

    public void setPrActualLicenseFee( String prActualLicenseFee ) {
        this.prActualLicenseFee = prActualLicenseFee;
    }

    public String getPrMinimumLicenseFee() {
        return prMinimumLicenseFee;
    }

    public void setPrMinimumLicenseFee( String prMinimumLicenseFee ) {
        this.prMinimumLicenseFee = prMinimumLicenseFee;
    }

    public Boolean getPrUpfrontPaymentRequired() {
        return prUpfrontPaymentRequired;
    }

    public void setPrUpfrontPaymentRequired( Boolean prUpfrontPaymentRequired ) {
        this.prUpfrontPaymentRequired = prUpfrontPaymentRequired;
    }

    public String getPrUpfrontPayment() {
        return prUpfrontPayment;
    }

    public void setPrUpfrontPayment( String prUpfrontPayment ) {
        this.prUpfrontPayment = prUpfrontPayment;
    }

    public Boolean getPrOverageRequired() {
        return prOverageRequired;
    }

    public void setPrOverageRequired( Boolean prOverageRequired ) {
        this.prOverageRequired = prOverageRequired;
    }

    public String getPrOverage() {
        return prOverage;
    }

    public void setPrOverage( String prOverage ) {
        this.prOverage = prOverage;
    }

    public Boolean getPrInstallmentPlanRequired() {
        return prInstallmentPlanRequired;
    }

    public void setPrInstallmentPlanRequired( Boolean prInstallmentPlanRequired ) {
        this.prInstallmentPlanRequired = prInstallmentPlanRequired;
    }

    public String getPrInstallmentPlan() {
        return prInstallmentPlan;
    }

    public void setPrInstallmentPlan( String prInstallmentPlan ) {
        this.prInstallmentPlan = prInstallmentPlan;
    }

    public Boolean getPrTieredPricingRequired() {
        return prTieredPricingRequired;
    }

    public void setPrTieredPricingRequired( Boolean prTieredPricingRequired ) {
        this.prTieredPricingRequired = prTieredPricingRequired;
    }

    public Boolean getPrRevenueShareRequired() {
        return prRevenueShareRequired;
    }

    public void setPrRevenueShareRequired( Boolean prRevenueShareRequired ) {
        this.prRevenueShareRequired = prRevenueShareRequired;
    }

    public UiCurrency getPrCurrency() {
        return prCurrency;
    }

    public void setPrCurrency( UiCurrency currency ) {
        this.prCurrency = currency;
    }

    /**
     * @param modified the modified to set
     */
    public void setModified( Boolean modified ) {
        this.modified = modified;
    }

    /**
     * @return the modified
     */
    public Boolean isModified() {
        return modified;
    }

    public List<UiDistributionManagement> getDistributionManagementList() {
        return distributionManagementList;
    }

    public List<UiLanguage> getLanguageList() {
        return languageList;
    }

    public List<UiUserDefinedFieldValue> getUserDefinedFieldValues() {
        return userDefinedFieldsValues;
    }

    public List<UiRevenuePricing> getRevenueSharedList() {
        return revenueSharedList;
    }

    public List<UiRevenuePricing> getTieredPricingList() {
        return tieredPricingList;
    }

    public List<UiLicenseDetails> getChildren() {
        return children;
    }

    public void addChild( UiLicenseDetails licenseDetails ) {
        this.children.add( licenseDetails );
    }

    public List<UiLicenseDetails> getAllChildren() {
        List<UiLicenseDetails> allChildren = new ArrayList<UiLicenseDetails>();
        allChildren.addAll( children );

        for ( UiLicenseDetails uiLicenseDetails : children ) {
            allChildren.addAll( uiLicenseDetails.getAllChildren() );
        }

        return allChildren;
    }

    public void resetUserDefinedFieldValues() {
        userDefinedFieldsValues.clear();
        for ( UiUserDefinedField field : license.getUserDefinedFields() ) {
            if ( !field.getScreenName().equals( CustomFieldFactory.LICENSE_SCREEN ) ) {
                userDefinedFieldsValues.add( createUserDefinedFieldValue( field ) );
            }
        }
    }

    private UiUserDefinedFieldValue createUserDefinedFieldValue( UiUserDefinedField field ) {
        UiUserDefinedFieldValue value = new UiUserDefinedFieldValue();
        value.setIdUserDefinedField( field.getIdUserDefinedField() );
        value.setValue( field.getDefaultValue() );
        return value;
    }

}
