package com.ericsson.cms.contractmgmt.client.model;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Collection of platforms with the total count
 * 
 * @author Daniel Paranhos
 * 
 */
public class UiPlatforms implements IsSerializable {

    private List<UiPlatform> platforms;
    private int totalCount;

    /**
     * Default constructor
     */
    public UiPlatforms() {
        if ( this.platforms == null ) {
            this.platforms = new ArrayList<UiPlatform>();
        }
    }

    /**
     * Constructor
     * 
     * @param platforms
     *            the list of platforms, not necessarily all platforms present in database if pagination is
     *            being used
     * @param totalCount
     *            the total count of platforms present in database
     */
    public UiPlatforms( List<UiPlatform> platforms, int totalCount ) {
        super();
        this.platforms = platforms;
        if ( this.platforms == null ) {
            this.platforms = new ArrayList<UiPlatform>();
        }
        this.totalCount = totalCount;
    }

    /**
     * Get the list of platforms
     * 
     * @return the platforms
     */
    public List<UiPlatform> getPlatforms() {
        return platforms;
    }

    /**
     * Set the total count of platforms present in database
     * 
     * @return the total count
     */
    public int getTotalCount() {
        return totalCount;
    }
}
