package com.ericsson.cms.contractmgmt.client.model;

import java.util.Date;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Revenue Shared / Tiered Pricing representation for the UI layer.
 * 
 * @author Daniel Paranhos
 */
public class UiRevenuePricing implements IsSerializable {

    private Long key;
    private String threshold;
    private Date fromDate;
    private Date toDate;
    private String price;
    private UiCurrency currency;
    private String penalty;

    /**
     * Default constructor
     */
    public UiRevenuePricing() {
    }

    /**
     * Constructor
     */
    public UiRevenuePricing( Long key ) {
        this.key = key;
    }

    /**
     * Get the key
     * 
     * @return the key
     */
    public Long getKey() {
        return key;
    }

    /**
     * Set the key
     * 
     * @param key
     *            the key to set
     */
    public void setKey( Long key ) {
        this.key = key;
    }

    public String getThreshold() {
        return threshold;
    }

    public void setThreshold( String threshold ) {
        this.threshold = threshold;
    }

    public Date getFromDate() {
        return fromDate;
    }

    public void setFromDate( Date fromDate ) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return toDate;
    }

    public void setToDate( Date toDate ) {
        this.toDate = toDate;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice( String price ) {
        this.price = price;
    }

    public UiCurrency getCurrency() {
        return currency;
    }

    public void setCurrency( UiCurrency currency ) {
        this.currency = currency;
    }

    public String getPenalty() {
        return penalty;
    }

    public void setPenalty( String penalty ) {
        this.penalty = penalty;
    }

}
