package com.ericsson.cms.contractmgmt.client.rpc;

import java.util.List;

import com.ericsson.cms.contractmgmt.client.model.UiContentProvider;
import com.ericsson.cms.contractmgmt.client.model.UiCurrency;
import com.ericsson.cms.contractmgmt.client.model.UiDeliveryLocation;
import com.ericsson.cms.contractmgmt.client.model.UiDevice;
import com.ericsson.cms.contractmgmt.client.model.UiDevices;
import com.ericsson.cms.contractmgmt.client.model.UiDistributionListValues;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNames;
import com.ericsson.cms.contractmgmt.client.model.UiPlatform;
import com.ericsson.cms.contractmgmt.client.model.UiPlatforms;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * RPC service which helps with all contract manager drop down operations.
 * 
 * @author Daniel Paranhos
 * 
 */
@RemoteServiceRelativePath("service/contract/contractManagerDropDownService")
public interface IContractManagerDropDownService extends RemoteService {

    /**
     * Returns the list of key/name representing copyright holders
     * 
     * @return the list of key/name
     */
    List<UiKeyName> getCopyrightHolderKeyNameList() throws NeptuneException;

    /**
     * Returns the list of key/name representing contracts for a given copyright holder
     * 
     * @param copyrightHolderKey
     *            the copyright holder key
     * @return the list of key/name
     */
    List<UiKeyName> getContractKeyNameList( Long copyrightHolderKey ) throws NeptuneException;

    /**
     * Returns the list of key/name representing deals with for a given contract
     * 
     * @param contractKey
     *            the contract key
     * @return the list of key/name
     */
    List<UiKeyName> getDealKeyNameList( Long contractKey ) throws NeptuneException;

    /**
     * Returns the distribution list of values to be used on list boxes
     * 
     * @return the distribution list of values
     */
    UiDistributionListValues getDistributionListValues() throws NeptuneException;

    /**
     * Returns the list of key/name representing field types
     * 
     * @return the list of key/name
     */
    List<UiKeyName> getFieldTypeKeyNameList() throws NeptuneException;

    /**
     * Returns the list of key/name representing drop-down values
     * 
     * @return the list of key/name
     */
    List<UiKeyName> getDropDownKeyNameList( Long userDefinedFieldId ) throws NeptuneException;

    /**
     * Save the key/name representing the custom drop down for the User-defined field
     * 
     * @param name
     *      the key/name to be saved
     * @param userDefinedFieldId
     *            the field id
     * @throws NeptuneException
     */
    void saveCustomDropDownKeyName(UiKeyName name, Long userDefinedFieldId) throws NeptuneException;

    /**
     * Deletes the list of key/names representing the custom drop down for the User-defined field
     * 
     * @param keyNames
     *      the list of key/names to be deleted
     * @throws NeptuneException
     */
    void deleteCustomDropDownKeyNames( List<UiKeyName> keyNames ) throws NeptuneException;

    /**
     * Get the list of all delivery locations
     * 
     * @return the list of all delivery locations
     */
    List<UiDeliveryLocation> getDeliveryLocationList() throws NeptuneException;

    /**
     * Get the list of platforms
     * 
     * @return the list of platforms
     */
    List<UiPlatform> getPlatformList() throws NeptuneException;
    
    /**
     * Returns the list of platforms
     * 
     * @param start
     *            the records start index
     * @param length
     *            the length of the records list
     * @param sortProperty
     *            the sort property
     * @param isAscending
     *            true if it is ascending, false otherwise
     * 
     * @return the list of platforms
     */
    UiPlatforms getPlatforms( int start, int length, String sortProperty, boolean isAscending )
            throws NeptuneException;

    /**
     * Returns the list of devices
     * 
     * @param start
     *            the records start index
     * @param length
     *            the length of the records list
     * @param sortProperty
     *            the sort property
     * @param isAscending
     *            true if it is ascending, false otherwise
     *            
     * @return the list of devices
     */
    UiDevices getDevices( int start, int length, String sortProperty, boolean isAscending )
            throws NeptuneException;

    /**
     * Save the device
     * 
     * @param device
     *      the device to be saved
     * @throws NeptuneException
     */
    void saveDevice(UiDevice device) throws NeptuneException;

    /**
     * Deletes the list of devices
     * 
     * @param devices
     *      the list of devices to be deleted
     * @throws NeptuneException
     */
    void deleteDevices( List<UiDevice> devices ) throws NeptuneException;

    /**
     * Get the list of devices for the given platforms
     * 
     * @param selectedPlatforms
     *            a list of platforms
     * 
     * @return the list of devices
     */
    List<UiDevice> getDeviceList( List<UiPlatform> selectedPlatforms ) throws NeptuneException;

    /**
     * Returns the list of key/name representing the given field
     *
     * @param start
     *            the records start index
     * @param length
     *            the length of the records list
     * @param sortProperty
     *            the sort property
     * @param isAscending
     *            true if it is ascending, false otherwise
     * @param fieldType
     *            the field type
     * 
     * @return the list of key/name
     */
    UiKeyNames getGenericDropDownKeyNameList( int start, int length, String sortProperty,
            boolean isAscending, ConfigurableFieldTypeEnum fieldType ) throws NeptuneException;
    
    /**
     * Save the key/name representing the given field
     * 
     * @param name
     *      the key/name to be saved
     * @param fieldType
     *      the field type that is to be saved
     * @throws NeptuneException
     */
    void saveGenericDropDownKeyName(UiKeyName name, ConfigurableFieldTypeEnum fieldType) throws NeptuneException;

    /**
     * Deletes the list of key/names represented by the given field
     * 
     * @param keyNames
     *      the list of key/names to be deleted
     * @param fieldType
     *      the field type
     * @throws NeptuneException
     */
    void deleteGenericDropDownKeyNames( List<UiKeyName> keyNames, ConfigurableFieldTypeEnum fieldType ) throws NeptuneException;

    /**
     * Returns the list currencies
     * 
     * @return the list of currencies
     */
    List<UiCurrency> getCurrencies() throws NeptuneException;

    /**
     * Save the currency
     * 
     * @param currency
     *      the currency to be saved
     * @throws NeptuneException
     */
    void saveCurrency(UiCurrency currency) throws NeptuneException;

    /**
     * Deletes the list of currencies
     * 
     * @param currencies
     *      the list of currencies to be deleted
     * @throws NeptuneException
     */
    void deleteCurrencies( List<UiCurrency> currencies ) throws NeptuneException;
    
    /**
     * Returns the list of key/name contract types
     * 
     * @return the list of key/name
     */
    List<UiKeyName> getContractTypeKeyNameList() throws NeptuneException;
    
    /**
     * Returns the list of key/name deal types
     * 
     * @return the list of key/name
     */
	List<UiKeyName> getDealTypeKeyNameList();

	/**
	 * Returns the list of content providers for the current user
	 * 
	 * @return the list of content providers
	 */
    List<UiContentProvider> getContentProvidersList();

}
