package com.ericsson.cms.contractmgmt.client.rpc;

import java.util.List;

import com.ericsson.cms.contractmgmt.client.model.UiContentProvider;
import com.ericsson.cms.contractmgmt.client.model.UiCurrency;
import com.ericsson.cms.contractmgmt.client.model.UiDeliveryLocation;
import com.ericsson.cms.contractmgmt.client.model.UiDevice;
import com.ericsson.cms.contractmgmt.client.model.UiDevices;
import com.ericsson.cms.contractmgmt.client.model.UiDistributionListValues;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNames;
import com.ericsson.cms.contractmgmt.client.model.UiPlatform;
import com.ericsson.cms.contractmgmt.client.model.UiPlatforms;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * RPC service which helps with all contract manager operations.
 * 
 * @author Daniel Paranhos
 * 
 */
public interface IContractManagerDropDownServiceAsync {

    /**
     * Returns the list of key/name representing copyright holders
     * 
     * @param callback
     *            the callback to return the results
     */
    void getCopyrightHolderKeyNameList( AsyncCallback<List<UiKeyName>> callback );

    /**
     * Returns the list of key/name representing contracts for a given copyright holder
     * 
     * @param copyrightHolderKey
     *            the copyright holder key
     * @param callback
     *            the callback to return the results
     */
    void getContractKeyNameList( Long copyrightHolderKey, AsyncCallback<List<UiKeyName>> callback );

    /**
     * Returns the list of key/name representing deals for a given contract
     * 
     * @param contractKey
     *            the contract key
     * @param callback
     *            the callback to return the results
     */
    void getDealKeyNameList( Long contractKey, AsyncCallback<List<UiKeyName>> callback );

    /**
     * Returns the distribution list of values to be used on list boxes
     * 
     * @param callback
     *            the callback to return the results
     */
    void getDistributionListValues( AsyncCallback<UiDistributionListValues> callback );

    /**
     * Returns the list of key/name representing field types
     * 
     * @param callback
     *            the callback to return the results
     */
    void getFieldTypeKeyNameList( AsyncCallback<List<UiKeyName>> callback );

    /**
     * Returns the list of key/name representing drop-down values
     * 
     * @param callback
     *            the callback to return the results
     */
    void getDropDownKeyNameList( Long userDefinedFieldId, AsyncCallback<List<UiKeyName>> callback );

    /**
     * Save the key/name representing the custom drop down for the User-defined field
     * 
     * @param name
     *            the key/name to be saved
     * @param userDefinedFieldId
     *            the field id
     * @param callback
     *            the callback to return the results
     */
    void saveCustomDropDownKeyName( UiKeyName name, Long userDefinedFieldId, AsyncCallback<Void> callback );

    /**
     * Deletes the list of key/names representing the custom drop down for the User-defined field
     * 
     * @param keyNames
     *            the list of key/names to be deleted
     * @param callback
     *            the callback to return the results
     */
    void deleteCustomDropDownKeyNames( List<UiKeyName> keyNames, AsyncCallback<Void> callback );

    /**
     * Get the list of all Delivery Locations
     * 
     * @param callback
     *            the callback to return the results
     */
    void getDeliveryLocationList( AsyncCallback<List<UiDeliveryLocation>> callback );

    /**
     * Get the list of platforms for the given delivery locations
     * 
     * @param callback
     *            the callback to return the results
     */
    void getPlatformList( AsyncCallback<List<UiPlatform>> callback );

    /**
     * Returns the list platforms
     * 
     * @param start
     *            the records start index
     * @param length
     *            the length of the records list
     * @param sortProperty
     *            the sort property
     * @param isAscending
     *            true if it is ascending, false otherwise
     * @param callback
     *            the callback to return the results
     */
    void getPlatforms( int start, int length, String sortProperty, boolean isAscending,
            AsyncCallback<UiPlatforms> callback );

    /**
     * Returns the list devices
     * 
     * @param start
     *            the records start index
     * @param length
     *            the length of the records list
     * @param sortProperty
     *            the sort property
     * @param isAscending
     *            true if it is ascending, false otherwise
     * @param callback
     *            the callback to return the results
     */
    void getDevices( int start, int length, String sortProperty, boolean isAscending,
            AsyncCallback<UiDevices> callback );

    /**
     * Save the device
     * 
     * @param device
     *            the device to be saved
     * @param callback
     *            the callback to return the results
     */
    void saveDevice( UiDevice device, AsyncCallback<Void> callback );

    /**
     * Deletes the list of devices
     * 
     * @param devices
     *            the list of devices to be deleted
     * @param callback
     *            the callback to return the results
     */
    void deleteDevices( List<UiDevice> devices, AsyncCallback<Void> callback );

    /**
     * Get the list of devices for the given platforms
     * 
     * @param selectedPlatforms
     *            a list of platforms
     * @param callback
     *            the callback to return the results
     */
    void getDeviceList( List<UiPlatform> selectedPlatforms, AsyncCallback<List<UiDevice>> callback );

    /**
     * Returns the list of key/name representing the given field
     * 
     * @param start
     *            the records start index
     * @param length
     *            the length of the records list
     * @param sortProperty
     *            the sort property
     * @param isAscending
     *            true if it is ascending, false otherwise
     * @param fieldType
     *            the field type
     * @param callback
     *            the callback to return the results
     */
    void getGenericDropDownKeyNameList( int start, int length, String sortProperty, boolean isAscending,
            ConfigurableFieldTypeEnum fieldType, AsyncCallback<UiKeyNames> callback );

    /**
     * Save the key/name representing the given field
     * 
     * @param name
     *            the key/name to be saved
     * @param fieldType
     *            the field type
     * @param callback
     *            the callback to return the results
     */
    void saveGenericDropDownKeyName( UiKeyName name, ConfigurableFieldTypeEnum fieldType, AsyncCallback<Void> callback );

    /**
     * Deletes the list of key/names represented by the given field
     * 
     * @param keyNames
     *            the list of key/names to be deleted
     * @param fieldType
     *            the field type
     * @param callback
     *            the callback to return the results
     */
    void deleteGenericDropDownKeyNames( List<UiKeyName> keyNames, ConfigurableFieldTypeEnum fieldType, AsyncCallback<Void> callback );

    /**
     * Returns the list currencies
     * 
     * @param callback
     *            the callback to return the results
     */
    void getCurrencies( AsyncCallback<List<UiCurrency>> callback );

    /**
     * Save the currency
     * 
     * @param currency
     *            the currency to be saved
     * @param callback
     *            the callback to return the results
     */
    void saveCurrency( UiCurrency currency, AsyncCallback<Void> callback );

    /**
     * Deletes the list of currencies
     * 
     * @param currencies
     *            the list of currencies to be deleted
     * @param callback
     *            the callback to return the results
     */
    void deleteCurrencies( List<UiCurrency> currencies, AsyncCallback<Void> callback );

    /**
     * Returns the list of key/name representing contract types
     * 
     * @param callback
     *            the callback to return the results
     */
    void getContractTypeKeyNameList( AsyncCallback<List<UiKeyName>> callback );

    /**
     * Returns the list of key/name representing deal types
     * 
     * @param callback
     *            the callback to return the results
     */
    void getDealTypeKeyNameList( AsyncCallback<List<UiKeyName>> callback );

    /**
     * Returns the list of content providers for the current user
     * 
     * @param callback
     *            the callback to return the results
     */
    void getContentProvidersList( AsyncCallback<List<UiContentProvider>> callback );

}
