package com.ericsson.cms.contractmgmt.client.rpc;



import java.util.List;

import java.util.Map;



import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;

import com.ericsson.cms.contractmgmt.client.model.AuditReportResult;

import com.ericsson.cms.contractmgmt.client.model.ContactSearchResult;

import com.ericsson.cms.contractmgmt.client.model.ContractSearchResult;

import com.ericsson.cms.contractmgmt.client.model.CopyrightHolderSearchResult;

import com.ericsson.cms.contractmgmt.client.model.DealSearchResult;

import com.ericsson.cms.contractmgmt.client.model.LicenseSearchResult;

import com.ericsson.cms.contractmgmt.client.model.UiAsset;

import com.ericsson.cms.contractmgmt.client.model.UiAudit;

import com.ericsson.cms.contractmgmt.client.model.UiContact;

import com.ericsson.cms.contractmgmt.client.model.UiContactType;

import com.ericsson.cms.contractmgmt.client.model.UiContract;

import com.ericsson.cms.contractmgmt.client.model.UiCopyrightHolder;

import com.ericsson.cms.contractmgmt.client.model.UiDeal;

import com.ericsson.cms.contractmgmt.client.model.UiLicense;

import com.ericsson.cms.contractmgmt.client.tab.license.UiLicenseRecord;

import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;

import com.google.gwt.user.client.rpc.RemoteService;

import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;



/**

 * RPC service which helps with all contract manager operations.

 * 

 * @author Daniel Paranhos

 * 

 */

@RemoteServiceRelativePath("service/contract/contractManagerService")

public interface IContractManagerService extends RemoteService {



    /**

     * Returns the list of user defined fields

     * 

     * @return the list of user defined fields

     */

    List<UiUserDefinedField> getUserDefinedFields( String screen ) throws NeptuneException;



    /**

     * Save the User Defined Field

     * 

     * @param userDefinedField

     *            the user defined field to be saved

     * @throws NeptuneException

     */

    void saveUserDefinedField( UiUserDefinedField userDefinedField ) throws NeptuneException;



    /**

     * Deletes the list of User-defined fields

     * 

     * @param userDefinedFields

     *            the list of fields to be deleted.

     * @throws NeptuneException

     */

    void deleteUserDefinedFields( List<UiUserDefinedField> userDefinedFields ) throws NeptuneException;



    /**

     * Returns the list of the license user defined fields

     * 

     * @return the list of the license user defined fields

     */

    List<UiUserDefinedField> getLicenseUserDefinedFields() throws NeptuneException;



    /**

     * Returns the list of user defined fields sorted by sortByProperty

     * 

     * @param sortByProperty

     *            the sort by column name

     * @param isAscending

     *            indicates if the order is ascending (true) or descending (false)

     * @param screen

     *            the screen name

     * @return the list of user defined fields

     */

    List<UiUserDefinedField> getUserDefinedFields( String sortByProperty, boolean isAscending, String screen )

            throws NeptuneException;



    /**

     * Saves a given license

     */

    void saveLicense( UiLicenseRecord license ) throws NeptuneException;



    /**

     * Deletes a given license

     */

    void deleteLicense( Long licenseId ) throws NeptuneException;



    /**

     * Deletes a list of licenses

     * 

     * @param records

     *            a list of license records to be deleted

     */

    void deleteLicenses( List<UiLicenseRecord> records ) throws NeptuneException;



    /**

     * Saves a given contact

     * 

     * @return true if the contact was saved successfully, false otherwise

     */

    Boolean saveContact( UiContact contact, UiContactType contactType, Long parentId )throws NeptuneException;



    /**

     * Returns the list UiContactRecord representing contacts for a given copyright holder

     * 

     * @param copyrightHolderKey

     *            the copyright holder key

     * @return the list of key/name

     */

    ContactSearchResult getCopyrightHolderContactList( Long copyrightHolderKey, String sortProperty, boolean isAscending ) throws NeptuneException;



    /**

     * Returns the list UiContactRecord representing contacts for a given contract

     * 

     * @param contractKey

     *            the contract key

     * @return the list of key/name

     */

    ContactSearchResult getContractContactList( Long contractKey, String sortProperty, boolean isAscending ) throws NeptuneException;



    /**

     * Deletes a list of given contacts

     * 

     * @param parentId

     *            the copyright holder, contract or deal key

     * 

     * @param contactType

     *            can be of types copyright holder, contract or deal

     * 

     * @param contactList

     *            the contact list to be deleted

     * 

     * @return true if the contacts were deleted successfully, false otherwise

     */

    Boolean deleteContacts( List<UiContact> contactList, UiContactType contactType, Long parentId ) throws NeptuneException;



    /**

     * Saves a given contract

     * 

     * 

     * @return true if the contract was saved successfully, false otherwise

     * @throws NeptuneException 

     */

    Boolean saveContract( UiContract contract ) throws NeptuneException;



    /**

     * Returns the list of all Contracts

     * 

     * @return the list of UiContract

     */

    ContractSearchResult getContractList(int start, int length, String sortProperty, boolean isAscending) throws NeptuneException;



    /**

     * Returns the list of all Contracts by Copyright Holder

     * 

     * @return the list of UiContract

     */

    List<UiContract> getCopyrightHolderContractList( Long copyrightHolderId ) throws NeptuneException;



    /**

     * Saves a given copyright holder

     * 

     * @return true if the contract was saved successfully, false otherwise

     */

    Boolean saveCopyrightHolder( UiCopyrightHolder copyrightHolder ) throws NeptuneException;



    /**

     * deletes a list of given copyright holders

     * 

     * @param list

     *            the copyright holders list

     * @return true if the contract was saved successfully, false otherwise

     */

    Boolean deleteCopyrightHolders( List<UiCopyrightHolder> list ) throws NeptuneException;



    /**

     * Returns the list UiCopyrightHolder

     * 

     * @return the list of UiCopyrightHolder

     */

    CopyrightHolderSearchResult getCopyrightHolderList(int start, int length, String sortProperty, boolean isAscending ) throws NeptuneException;



    /**

     * deletes a given contract

     * 

     * @param list

     *            the contract list

     * @return true if the operation was successful, false otherwise

     */

    Boolean deleteContracts( List<UiContract> list ) throws NeptuneException;



    /**

     * deletes a given deal

     * 

     * @param list

     *            the deal list

     * @return true if the operation was successful, false otherwise

     */

    Boolean deleteDeals( List<UiDeal> list ) throws NeptuneException;



    /**

     * Returns the list of all Deals by Contracts

     * 

     * @param key

     *            the contract id

     * 

     * @return the list of UiContract

     */

    List<UiDeal> getContractDealsList( Long key ) throws NeptuneException;



    /**

     * Returns the list of all Licenses by Deal

     * 

     * @param key

     *            the deal id

     * 

     * @return the list of UiLicense

     */

    List<UiLicense> getDealsLicenseList( Long key ) throws NeptuneException;



    /**

     * Get a given contract

     * 

     * @param key

     *            the contract key to be retrieved

     * @return the contract

     */

    UiContract getContract( Long key ) throws NeptuneException;



    /**

     * Returns the list of all Deals

     * 

     * @return the list of UiDeal

     */

    DealSearchResult getDealsList(int start, int length, String sortProperty, boolean isAscending) throws NeptuneException;



    /**

     * Saves a given deal

     * 

     * @param deal

     *            the deal record to be saved

     * 

     * @return true if the operation was successful, false otherwise

     * @throws NeptuneException

     */

    Boolean saveDeal( UiDeal deal ) throws NeptuneException;



    /**

     * Gets a given deal

     * 

     * @param key

     *            the deal id

     * 

     * @return the deal

     */

    UiDeal getDeal( Long key ) throws NeptuneException;



    /**

     * Gets a list of licenses

     * 

     * @return the list of licenses

     */

    LicenseSearchResult getLicenseList( int start, int length, String sortProperty, boolean isAscending )

            throws NeptuneException;



    /**

     * Gets a given license

     * 

     * @param key

     *            the license id

     * @return the license

     */

    UiLicense getLicense( Long key ) throws NeptuneException;



    /**

     * Gets a given license and its license details

     * 

     * @param key

     *            the license id

     * @return the license

     */

    UiLicense getFullLicense( Long key ) throws NeptuneException;



    /**

     * Returns the list of UiContactsRecord representing contacts for a given copyright holder

     * 

     * @param contactKey

     *            the contact key

     * @param callback

     *            the callback to return the results

     */

    UiContact getContact( long contactKey );



    /**

     * Get a Copyright Holder

     * 

     * @param Key

     *            the copyright holder key

     * @param callback

     *            the callback to return the results

     */

    UiCopyrightHolder getCopyrightHolder( long copyrightHolderKey );



    /**

     * Returns the list of UiDealsRecord representing contacts for a given deal

     * 

     * @param dealKey

     *            the deal key

     * @param callback

     *            the callback to return the results

     */

    ContactSearchResult getDealContactList( Long dealKey , String sortProperty, boolean isAscending);



    /**

     * Adds assets to the given License

     * 

     * @param licenseId

     *            The license id

     * @param titleIds

     *            the list of title ids

     * @throws NeptuneException

     */

    void addAssetsToLicense( long licenseId, List<Long> titleIds ) throws NeptuneException;



    /**

     * Remove assets from the given License

     * 

     * @param licenseId

     *            The license id

     * @param titleIds

     *            the list of title ids

     * @throws NeptuneException

     */

    void removeAssetsFromLicense( long licenseId, List<Long> titleIds ) throws NeptuneException;



    /**

     * Gets the list of assets for the given ids

     * 

     * @param assetIds

     *            The list of asset ids

     * @return The list of assets

     * @throws NeptuneException

     */

    List<UiAsset> getAssets( List<Long> assetIds ) throws NeptuneException;



    /**

     * Get a map with errors from http session

     * 

     * @param licenseId the license list id

     * @return the map with errors

     * @throws NeptuneException

     */

    Map<String, Object> getLicenseErrorsFromHttpSession( long licenseId ) throws NeptuneException;

    

    /**

      * Gets the list of audits according to the parameters 

      * passed as filters 

      * 

      * @param UiAuditFilter

      *            

      * @return The list of audits

      * @throws NeptuneException

      */

     AuditReportResult findAuditsByFilter(int start, int length,String sortProperty,boolean isAscending,UiAudit uiAuditFilter)  throws NeptuneException;



    /**

     * Saves the ScheduleInfo (ScheduleRule) for email notifications

     * to be sent for all the expiring contracts, deals and licenses.

     * 

     * @param scheduleInfo

     * @throws NeptuneException

     */

	void saveSchedule(ScheduleInfo scheduleInfo) throws NeptuneException;



	/**

	 * Returns the ScheduleRule for the email notifications job.

	 * @return

	 * @throws NeptuneException

	 */

	ScheduleInfo getSchedule() throws NeptuneException;

    

}

