package com.ericsson.cms.contractmgmt.client.rpc;



import java.util.List;

import java.util.Map;



import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;

import com.ericsson.cms.contractmgmt.client.model.AuditReportResult;

import com.ericsson.cms.contractmgmt.client.model.ContactSearchResult;

import com.ericsson.cms.contractmgmt.client.model.ContractSearchResult;

import com.ericsson.cms.contractmgmt.client.model.CopyrightHolderSearchResult;

import com.ericsson.cms.contractmgmt.client.model.DealSearchResult;

import com.ericsson.cms.contractmgmt.client.model.LicenseSearchResult;

import com.ericsson.cms.contractmgmt.client.model.UiAsset;

import com.ericsson.cms.contractmgmt.client.model.UiAudit;

import com.ericsson.cms.contractmgmt.client.model.UiContact;

import com.ericsson.cms.contractmgmt.client.model.UiContactType;

import com.ericsson.cms.contractmgmt.client.model.UiContract;

import com.ericsson.cms.contractmgmt.client.model.UiCopyrightHolder;

import com.ericsson.cms.contractmgmt.client.model.UiDeal;

import com.ericsson.cms.contractmgmt.client.model.UiLicense;

import com.ericsson.cms.contractmgmt.client.tab.license.UiLicenseRecord;

import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;

import com.google.gwt.user.client.rpc.AsyncCallback;



/**

 * RPC service which helps with all contract manager operations.

 * 

 * @author Daniel Paranhos

 * 

 */

public interface IContractManagerServiceAsync {



    /**

     * Returns the list of user defined fields

     * 

     * @param screen

     *            the screen name

     * @param callback

     *            the callback to return the results

     */

    void getUserDefinedFields( String screen, AsyncCallback<List<UiUserDefinedField>> callback );



    /**

     * Save the User Defined Field

     * 

     * @param userDefinedField

     *            the user defined field to be saved

     * @param callback

     *            the callback to return the results

     */

    void saveUserDefinedField( UiUserDefinedField userDefinedField, AsyncCallback<Void> callback );



    /**

     * Deletes the list of User-defined fields

     * 

     * @param userDefinedFields

     *            the list of fields to be deleted.

     * @param callback

     *            the callback to return the results

     */

    void deleteUserDefinedFields( List<UiUserDefinedField> userDefinedFields, AsyncCallback<Void> callback );



    /**

     * Returns the list of the license user defined fields

     * 

     * @param callback

     *            the callback to return the results

     */

    void getLicenseUserDefinedFields( AsyncCallback<List<UiUserDefinedField>> callback );



    /**

     * Returns the list of user defined fields sorted by sortByProperty

     * 

     * @param sortByProperty

     *            the sort by column name

     * @param isAscending

     *            indicates if the order is ascending (true) or descending (false)

     * @param screen

     *            the screen name

     * @param callback

     *            the callback to return the results

     */

    void getUserDefinedFields( String sortByProperty, boolean isAscending, String screen,

            AsyncCallback<List<UiUserDefinedField>> callback );



    /**

     * Saves a given license

     * 

     * @param license

     *            the license record to be saved

     * @param callback

     *            the callback to return the results

     */

    void saveLicense( UiLicenseRecord license, AsyncCallback<Void> callback );



    /**

     * Deletes a given license

     * 

     * @param licenseId

     *            the license id

     * @param callback

     *            the callback to return the results

     */

    void deleteLicense( Long licenseId, AsyncCallback<Void> callback );



    /**

     * Deletes a list of licenses

     * 

     * @param records

     *            a list of license records to be deleted

     * @param callback

     *            the callback to return the results

     */

    void deleteLicenses( List<UiLicenseRecord> records, AsyncCallback<Void> callback );



    /**

     * Saves a given contact

     * 

     * @param contact

     *            the contact to be saved

     *            

     * @param contactType

     *            the contact type to be saved    

     *  

     * @param parentId

     *            the parentId to be saved            

     *                   

     * @param callback

     *            the callback to return the results

     */

    void saveContact( UiContact contact, UiContactType contactType, Long parentId, AsyncCallback<Boolean> callback );



    /**

     * Returns the list of UiContactsRecord representing contacts for a given copyright holder

     * 

     * @param copyrightHolderKey

     *            the copyright holder key

     * @param callback

     *            the callback to return the results

     */

    void getCopyrightHolderContactList( Long copyrightHolderKey, String sortProperty,

            boolean isAscending, AsyncCallback<ContactSearchResult> callback );

    

    /**

     * Returns the list of UiContactsRecord representing contacts for a given contract

     * 

     * @param contractKey

     *            the contract holder key

     * @param callback

     *            the callback to return the results

     */

    void getContractContactList( Long contractKey, String sortProperty,

            boolean isAscending, AsyncCallback<ContactSearchResult> callback );

    

    /**

     * Returns the list of UiDealsRecord representing contacts for a given deal

     * 

     * @param dealKey

     *            the deal key

     * @param callback

     *            the callback to return the results

     */

    void getDealContactList( Long dealKey,String sortProperty,

            boolean isAscending, AsyncCallback<ContactSearchResult> callback );



    /**

     * Delete a list of given contacts

     * 

     * @param contactList

     *            the contact to be saved

     *            

     * @param contactType

     *            the contact type to be saved    

     *  

     * @param parentId

     *            the parentId to be saved            

     *                   

     * @param callback

     *            the callback to return the results

     */

    void deleteContacts( List<UiContact> contactList, UiContactType contactType, Long parentId, AsyncCallback<Boolean> callback );



    /**

     * Save a given contract

     * 

     * @param contract

     *            the contract to be saved

     * @param callback

     *            the callback to return the results

     * 

     */

    void saveContract( UiContract contract, AsyncCallback<Boolean> callback );



    /**

     * Returns the list of all Contracts

     * 

     * @return the list of UiContract

     */

    void getContractList(int start, int length, String sortProperty,

            boolean isAscending, AsyncCallback<ContractSearchResult> callback );



    /**

     * Returns the list of all Contracts by Copyright Holder

     * 

     * @param copyrightHolderId

     *            the copyright holder id

     * @return the list of UiContract

     */

    void getCopyrightHolderContractList( Long copyrightHolderId, AsyncCallback<List<UiContract>> callback );



    /**

     * Saves a given copyright holder

     * 

     * @param copyrightHolder

     *            the copyright holder record to be saved

     * @param callback

     *            the callback to return the results

     */

    void saveCopyrightHolder( UiCopyrightHolder copyrightHolder, AsyncCallback<Boolean> callback );



    /**

     * Deletes a given copyright holder

     * 

     * @param list

     *            the copyright holder list to be deleted

     * @param callback

     *            the callback to return the results

     */

    void deleteCopyrightHolders( List<UiCopyrightHolder> list, AsyncCallback<Boolean> callback );



    /**

     * Returns the list UiCopyrightHolder

     * 

     * @return the list of UiCopyrightHolder

     */

    void getCopyrightHolderList( int start, int length, String sortProperty,

            boolean isAscending, AsyncCallback<CopyrightHolderSearchResult> callback );



    /**

     * Deletes a given contract

     * 

     * @param list

     *            the contract list

     * @param callback

     *            the callback to return the results

     */

    void deleteContracts( List<UiContract> list, AsyncCallback<Boolean> callback );



    /**

     * Deletes a given contract

     * 

     * @param list

     *            the deal list

     * @param callback

     *            the callback to return the results

     */

    void deleteDeals( List<UiDeal> list, AsyncCallback<Boolean> callback );



    /**

     * Returns the list of all Deals by Contracts

     * 

     * @param key

     *            the Contract id

     * @return the list of UiContract

     */

    void getContractDealsList( Long key, AsyncCallback<List<UiDeal>> callback );



    /**

     * Returns the list of all Licenses by Deal

     * 

     * @param key

     *            the deal id

     * @return the list of UiLicense

     */

    void getDealsLicenseList( Long key, AsyncCallback<List<UiLicense>> callback );



    /**

     * Get a given contract

     * 

     * @param key

     *            the contract id

     * @param callback

     *            the callback to return the results

     * */

    void getContract( Long key, AsyncCallback<UiContract> callback );



    /**

     * Returns the list of all Deals

     * 

     * @return the list of UiDeal

     */

    void getDealsList( int start, int length, String sortProperty,

            boolean isAscending, AsyncCallback<DealSearchResult> callback );



    /**

     * Saves a given deal

     * 

     * @param deal

     *            the deal record to be saved

     * @param callback

     *            the callback to return the results

     */

    void saveDeal( UiDeal deal, AsyncCallback<Boolean> callback );



    /**

     * Gets a given deal

     * 

     * @param key

     *            the deal id

     * @param callback

     *            the callback to return the results

     */

    void getDeal( Long key, AsyncCallback<UiDeal> callback );



    /**

     * Gets a list of licenses

     * 

     * @param callback

     *            the callback to return the results

     */

    void getLicenseList( int start, int length, String sortProperty,

            boolean isAscending, AsyncCallback<LicenseSearchResult> callback );

    

    



    /**

     * Gets a given license

     * 

     * @param key

     *            the license id

     * @param callback

     *            the callback to return the results

     */

    void getLicense( Long key, AsyncCallback<UiLicense> callback );

    

    /**

     * Gets a given license and its license details

     * 

     * @param key

     *            the license id

     * @param callback

     *            the callback to return the results

     */

    void getFullLicense( Long key, AsyncCallback<UiLicense> callback );



    /**

     * Returns the list of UiContactsRecord representing contacts for a given copyright holder

     * 

     * @param contactKey

     *            the contact key

     * @param callback

     *            the callback to return the results

     */

    void getContact(long contactKey, AsyncCallback<UiContact> callback);

    

    

    /**

     * Get a Copyright Holder

     * 

     * @param Key

     *            the copyright holder key

     * @param callback

     *            the callback to return the results

     */

    void getCopyrightHolder(long copyrightHolderKey, AsyncCallback<UiCopyrightHolder> callback);

    

    /**

     * Adds assets to the given License

     * 

     * @param licenseId

     *            The license id

     * @param titleIds

     *            the list of title ids

     * @param callback

     *            the callback to return the results

     */

    void addAssetsToLicense( long licenseId, List<Long> titleIds, AsyncCallback<Void> callback );



    /**

     * Removes assets from the given License

     * 

     * @param licenseId

     *            The license id

     * @param titleIds

     *            the list of title ids

     * @param callback

     *            the callback to return the results

     */

    void removeAssetsFromLicense( long licenseId, List<Long> titleIds, AsyncCallback<Void> callback );



    /**

     * Gets the list of assets for the given ids

     * 

     * @param assetIds

     *            The list of asset ids

     * @param callback

     *            the callback to return the results

     */

    void getAssets( List<Long> assetIds, AsyncCallback<List<UiAsset>> callback );



    /**

     * Get a map with errors from http session

     * 

     * @param licenseId

     *            the license list id

     * @param callback

     *            the callback to return the results

     */

    void getLicenseErrorsFromHttpSession( long licenseId, AsyncCallback<Map<String, Object>> callback );



 	/**

     * Gets the list of audits according to the parameters 

     * passed as filters 

     * 

     * @param userName

     *            name of user logged

     * @param startDate

     * @param endDate

     * @param auditType

     *            

     * @return The list of audits

     */

    void findAuditsByFilter(int start, int length,String sortProperty, boolean isAscending,UiAudit uiAuditFilter, AsyncCallback<AuditReportResult> callback);



    /**

     * Saves the ScheduleInfo (ScheduleRule) for email notifications

     * to be sent for all the expiring contracts, deals and licenses.

     * 

     * @param scheduleInfo

     * @param callback

     */

	void saveSchedule(ScheduleInfo scheduleInfo, AsyncCallback<Void> callback);



	/**

	 * Returns the ScheduleRule for the email notifications job.

	 * @return

	 * @param callback

	 */

	void getSchedule(AsyncCallback<ScheduleInfo> callback);

}

