package com.ericsson.cms.contractmgmt.client.services;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.exception.UiContractManagerException;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.TitleActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class AddAssetToLicense implements ITitleService {

    private ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );

    private ContractComponentMessages messages = (ContractComponentMessages) GWT
            .create( ContractComponentMessages.class );

    private IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync) GWT
            .create( IContractManagerService.class );

    private static final Map<String, String> _serviceActionParameters;
	static {
		_serviceActionParameters = new HashMap<String, String>();
		_serviceActionParameters.put("TITLE_TYPE", "MASTER");
		_serviceActionParameters.put("UPDATE_TYPE", "MULTIPLE");
	}

    @Override
    public void execute( final List<Long> assetIds, String serviceParameter, IActionInput input,
            final AsyncCallback<IOperationResult> callback ) {

        final TitleActionInput actionInput = (TitleActionInput) input;
        if ( actionInput.getLicenseId() == 0 ) {
            callback.onFailure( new UiContractManagerException( messages.licenseRequiredFailure() ) );
            return;
        }
        contractManagerService.addAssetsToLicense( actionInput.getLicenseId(), assetIds,
                new NeptuneAsyncCallback<Void>() {
                    @Override
                    public void onNeptuneFailure( Throwable caught ) {
                        Window.alert( caught.getLocalizedMessage() );
                    }

                    @Override
                    public void onNeptuneSuccess( Void result ) {
                        callback.onSuccess( new AddAssetToLicenseResult( actionInput.getLicenseId() ) );
                    }
                } );
    }

    @Override
    public String getDescription() {
        return constants.addAssetToLicense();
    }

    @Override
    public String getName() {
        return constants.addAssetToLicenseServiceName();
    }

    @Override
    public void getServiceParameters( NeptuneAsyncCallback<List<String>> callback ) {
        callback.onSuccess( null );
    }
    
    @Override
	public Map<String, String> getServiceActionParameters() {
		return _serviceActionParameters;
	}

    @Override
    public void gotoResultPage( IOperationResult result, IView sourceView ) {
        History.newItem("Contracts.License.Edit?id="
                + ( (AddAssetToLicenseResult) result ).getLicenseId() );
    }

    @Override
    public boolean getConfirmation() {
        return false;
    }

    @Override
    public boolean isSelected( ViewInput inputData ) {
        return inputData.getLicenseId() == 0 ? false : true;
    }
    
    @Override
	public boolean needTitlesTobeSelected() {
		return true;
	}

}
