package com.ericsson.cms.contractmgmt.client.tab;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasHorizontalAlignment.HorizontalAlignmentConstant;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;

public class ContractFormContainer extends FormContainer {

    private final Map<Widget, Boolean> requiredMap = new HashMap<Widget, Boolean>();

    /* The default dependent style name to use for widgets in error state */
    protected static final String ERROR_STYLE = "dataTypeError";

    private final ContractComponentMessages messages = (ContractComponentMessages) GWT
            .create( ContractComponentMessages.class );

    public ContractFormContainer( HorizontalAlignmentConstant buttonPanelHAlign ) {
        super( buttonPanelHAlign );
    }

    @Override
    public int addRow( LabelWidget label, Widget value, boolean markRequired ) {
        requiredMap.put( value, markRequired );
        return super.addRow( label, value, markRequired );
    }

    public boolean validate() {
        boolean valid = true;
        clearAllValidationErrors();
        Set<Entry<Widget, Boolean>> entrySet = requiredMap.entrySet();
        for ( Entry<Widget, Boolean> entry : entrySet ) {
            Widget widget = entry.getKey();
            if ( widget instanceof Panel ) {
                Panel panel = (Panel) widget;
                Iterator<Widget> childrenIt = panel.iterator();
                while ( childrenIt.hasNext() ) {
                    Widget childWidget = childrenIt.next();
                    if ( !validate( childWidget, entry.getValue() ) ) {
                        valid = false;
                    }
                }
            } else if ( !validate( widget, entry.getValue() ) ) {
                valid = false;
            }

        }

        return valid;
    }

    private boolean validate( Widget widget, boolean required ) {
        boolean valid = true;

        FocusWidget focusWidget = null;
        if ( widget instanceof FocusWidget ) {
            focusWidget = (FocusWidget) widget;
        }
        DataTypeWidget<?> dataTypeWidget = null;
        if ( widget instanceof DataTypeWidget<?> ) {
            dataTypeWidget = (DataTypeWidget<?>) widget;
        }

        // validate required fields ignoring disabled widgets
        if ( required && ( focusWidget == null || focusWidget.isEnabled() )
                && ( dataTypeWidget == null || dataTypeWidget.isEnabled() ) ) {
            if (widget instanceof HasValue<?>) {   // NOSONAR
                HasValue<?> valueWidget = (HasValue<?>) widget;
                Object value = valueWidget.getValue();
                if ( value == null ) {
                    valid = false;
                    markRequiredError( widget );
                } else if ( value instanceof String ) {
                    String stringValue = (String) value;
                    if ( stringValue.trim().equals( "" ) ) {
                        valid = false;
                        markRequiredError( widget );
                    }
                }
            }
        }

        // validate field value
        if (dataTypeWidget != null && dataTypeWidget.isEnabled()
                && (!dataTypeWidget.isValidValue() || dataTypeWidget.hasValidationError())) {
            valid = false;
        }

        return valid;
    }

    public void clearAllValidationErrors() {
        Set<Widget> widgets = requiredMap.keySet();
        for ( Widget widget : widgets ) {
            if ( widget instanceof Panel ) {
                Panel panel = (Panel) widget;
                Iterator<Widget> childrenIt = panel.iterator();
                while ( childrenIt.hasNext() ) {
                    Widget childWidget = childrenIt.next();
                    clearValidationError( childWidget );
                }
            } else {
                clearValidationError( widget );
            }

        }
    }

    private void clearValidationError( Widget widget ) {
        if ( widget instanceof DataTypeWidget<?> ) {
            ( (DataTypeWidget<?>) widget ).clearValidationError();
        } else {
            widget.removeStyleDependentName( ERROR_STYLE );
        }
    }

    private void markRequiredError( Widget widget ) {
        if ( widget instanceof DataTypeWidget<?> ) {
            DataTypeWidget<?> dataTypeWidget = (DataTypeWidget<?>) widget;
            if ( dataTypeWidget.isValidValue() ) {
                dataTypeWidget.showValidationError( messages.fieldRequiredValidationErrorTooltip() );
            }
        } else {
            widget.addStyleDependentName( ERROR_STYLE );
            widget.setTitle( messages.fieldRequiredValidationErrorTooltip() );
        }
    }

}
