package com.ericsson.cms.contractmgmt.client.tab.audit;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.customfield.AuditActionEnum;
import com.ericsson.cms.contractmgmt.client.customfield.AuditTypeEnum;
import com.ericsson.cms.contractmgmt.client.model.AuditReportResult;
import com.ericsson.cms.contractmgmt.client.model.UiAudit;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

public class AuditDataProvider implements DataProvider<Long, UiAuditRecord> {
	
	  // filter audit
	  UiAudit uiaudit;
	  
	  // columns for this table
    private final List<Column<?, UiAuditRecord>> columns;
    private final ColumnBase<String, UiAuditRecord> dateColumn;
    private final ColumnBase<String, UiAuditRecord> nameColumn;
    private final ColumnBase<String, UiAuditRecord> typeColumn;
    private final ColumnBase<String, UiAuditRecord> actionColumn;
    private final ColumnBase<String, UiAuditRecord> messageColumn;

    private ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );

    private IContractManagerServiceAsync contractManagerService = GWT.create( IContractManagerService.class );

    private PageFeature parentPageFeature;
    private SortFeatureImpl<Long, UiAuditRecord> parentSortFeature;

    // column names
    private static final String DATE_COLUMN = "createDate";
    private static final String NAME_COLUMN = "userName";
    private static final String TYPE_COLUMN = "auditType";
    private static final String ACTION_COLUMN = "auditAction";
    private static final String MESSAGE_COLUMN = "auditMessage";

    private IBusyNotifier busyNotifier;

    public AuditDataProvider( AuditListPanel auditListPanel ) {
    

    	columns = new ArrayList<Column<?, UiAuditRecord>>();

        
        dateColumn = new ColumnBase<String, UiAuditRecord>( DATE_COLUMN, constants.auditTableCreateDate() ) {
            public View<String> getView( UiAuditRecord record ) {
            	DateTimeFormat dateFormatter = DateTimeFormat.getFormat( constants.dateFormat() );
                return new LabelStringView( dateFormatter.format( record.getAudit().getCreateDate() ) );
            }
        };
        dateColumn.setCellStyle( TableConstants.STYLE_DATACELL_DATE );
        columns.add( dateColumn );
                
        nameColumn = new ColumnBase<String, UiAuditRecord>( NAME_COLUMN, constants.auditTableUserName() ) {
            public View<String> getView( UiAuditRecord record ) {
            	return new LabelStringView( String.valueOf( record.getAudit().getUserName() ) );
            }
        };
        nameColumn.setCellStyle( TableConstants.STYLE_DATACELL_TEXT );
        columns.add( nameColumn );

        typeColumn = new ColumnBase<String, UiAuditRecord>( TYPE_COLUMN, constants.auditTableAuditType() ) {
            public View<String> getView( UiAuditRecord record ) {
                return new LabelStringView( AuditTypeEnum.getTextByValue(record.getAudit().getAuditType()) );
            }
        };
        typeColumn.setCellStyle( TableConstants.STYLE_DATACELL_TEXT );
        columns.add( typeColumn );

        actionColumn = new ColumnBase<String, UiAuditRecord>( ACTION_COLUMN,
                constants.auditTableAuditAction()) {
            public View<String> getView( UiAuditRecord record ) {
            	return new LabelStringView( AuditActionEnum.getTextByValue(record.getAudit().getAuditAction()) );
            }
        };
        actionColumn.setCellStyle( TableConstants.STYLE_DATACELL_TEXT );
        columns.add( actionColumn );
        
        messageColumn = new ColumnBase<String, UiAuditRecord>( MESSAGE_COLUMN,
                constants.auditTableMessage() ) {
            public View<String> getView( UiAuditRecord record ) {
            	return new LabelStringView( record.getAudit().getAuditMessage());
            }
        };
        messageColumn.setCellStyle( TableConstants.STYLE_DATACELL_TEXT );
        columns.add( messageColumn );

    }

    public ColumnBase<String, UiAuditRecord> getDefaultSortColumn() {
        return nameColumn;
    }

    public List<Column<?, UiAuditRecord>> getSortColumns() {
        return columns;
    }

    @Override
    public List<Column<?, UiAuditRecord>> getColumns() {
        return columns;
    }

    @Override
    public void getRecord( Long key, final AsyncCallback<UiAuditRecord> callback ) {

    }

    @Override
    public void getRecords( final AsyncCallback<List<UiAuditRecord>> callback ) {
        int length = getParentPageFeature().getPageSize();
        int start = (getParentPageFeature().getPageNumber() - 1) * length;
        notifyBusyStart();
        
      
			contractManagerService.findAuditsByFilter( start, length,getParentSortFeature().getSortColumnName(), 
	                getParentSortFeature().isAscending(), uiaudit, new NeptuneAsyncCallback<AuditReportResult>() {

			    @Override
			    public void onNeptuneFailure( Throwable caught ) {
			        getParentPageFeature().setRecordCount(-1);
			        callback.onFailure( caught );
			        notifyBusyFinish();
			    }

			    @Override
			    public void onNeptuneSuccess( AuditReportResult result ) {
			        getParentPageFeature().setRecordCount(result.getTotalCount());
			        List<UiAuditRecord> UiAuditRecords = new ArrayList<UiAuditRecord>();
			                for ( UiAudit uiAudit : result.getUiAuditsList() ) {
			            UiAuditRecords.add( new UiAuditRecord( uiAudit ) );
			        }
			        callback.onSuccess( UiAuditRecords );
			        notifyBusyFinish();
			    }

			} );
	
    }
    
    @Override
    public void initialize( AsyncCallback<Void> callback ) {
        callback.onSuccess( null );
    }

    @Override
    public boolean isCheckboxEnabled() {
        return true;
    }

    @Override
    public boolean isRecordCountEnabled() {
        return true;
    }

    /**
     * @return the parentPageFeature
     */
    public PageFeature getParentPageFeature() {
        return parentPageFeature;
    }

    /**
     * @param parentPageFeature
     *            the parentPageFeature to set
     */
    public void setParentPageFeature( PageFeature parentPageFeature ) {
        this.parentPageFeature = parentPageFeature;
    }

    /**
     * @return the parentSortFeature
     */
    public SortFeatureImpl<Long, UiAuditRecord> getParentSortFeature() {
        return parentSortFeature;
    }

    /**
     * @param parentSortFeature
     *            the parentSortFeature to set
     */
    public void setParentSortFeature( SortFeatureImpl<Long, UiAuditRecord> parentSortFeature ) {
        this.parentSortFeature = parentSortFeature;
    }

    public static interface IBusyNotifier {
        void startingToBeBusy();

        void doneBeingBusy();
    }

    public void setBusyNotifier( IBusyNotifier busyNotifier ) {
        this.busyNotifier = busyNotifier;
    }
    
    public void setAuditReportFilter(UiAudit uiaudit){
    	this.uiaudit = uiaudit;
    }

    private void notifyBusyStart() {
        if ( busyNotifier != null ) {
            busyNotifier.startingToBeBusy();
        }
    }

    private void notifyBusyFinish() {
        if ( busyNotifier != null ) {
            busyNotifier.doneBeingBusy();
        }
    }


}
