package com.ericsson.cms.contractmgmt.client.tab.audit;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.model.UiAudit;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;
import com.ericsson.cms.contractmgmt.client.tab.audit.AuditDataProvider.IBusyNotifier;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class AuditListPanel extends Composite {
	
	// table related
    private final AuditDataProvider dataProvider;
    private PageFeature pageFeature;
    private SortFeatureImpl<Long, UiAuditRecord> sortFeature;
    private BookmarkFeature bookmarkFeature;
    
    // widgets used in this view
    private VerticalContainer mainContainer;
    private Table<Long, UiAuditRecord> table;
    private final BusyIndicator busyIndicator = new BusyIndicator();

    private HeaderPanel header;
    
    private final SuccessPanel successPanel = new SuccessPanel();
    private final ErrorPanel errorPanel = new ErrorPanel();
    

    private final ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );

    // spacing between the table and message panel
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-ContractPanel";

    public AuditListPanel(UiAudit uiaudit) {
        this.dataProvider = new AuditDataProvider( this );
        dataProvider.setAuditReportFilter(uiaudit);
        dataProvider.setBusyNotifier( new IBusyNotifier() {
            @Override
            public void startingToBeBusy() {
                busyIndicator.center();
            }

            @Override
            public void doneBeingBusy() {
                busyIndicator.hide();
            }
        } );
        init();
    }
    
    public SuccessPanel getSuccessPanel() {
        return successPanel;
    }

    public ErrorPanel getErrorPanel() {
        return errorPanel;
    }

    private void init() {
        initWidgets();
        setContainers();
    }

    private void setContainers() {
        mainContainer.add( header );
        mainContainer.add( successPanel );
        mainContainer.add( errorPanel );
        mainContainer.add( table );
    }

    private void initWidgets() {
        mainContainer = new VerticalContainer();
        mainContainer.setSpacing( SPACING );
        mainContainer.setStylePrimaryName( STYLE_NAME );
        this.initWidget( mainContainer );

        header = new HeaderPanel( "" );

        table = new Table<Long, UiAuditRecord>( dataProvider );
        table.addTableViewChangeHandler( new TableViewChangeHandler<Long, UiAuditRecord>() {
            @Override
            public void onShowDetailView( TableDetailViewEvent<Long, UiAuditRecord> event ) {
                
            }

            @Override
            public void onShowListView( TableViewEvent event ) {
                header.setLabel( constants.auditReportResultTitle() );
            }
        } );

        // page feature
        pageFeature = new PageFeatureImpl();
        dataProvider.setParentPageFeature( pageFeature );

        // sort feature
        sortFeature = new SortFeatureImpl<Long, UiAuditRecord>(
                dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING );
        for ( Column<?, UiAuditRecord> col : dataProvider.getSortColumns() ) {
            sortFeature.addSortableColumn( col );
        }
        dataProvider.setParentSortFeature( sortFeature );

       //bookmark feature;
       bookmarkFeature = new BookmarkFeatureImpl();   

        table.addSortFeature( sortFeature );
        table.addPageFeature( pageFeature );
        table.addBookmarkFeature( bookmarkFeature );

        table.initialize( new NeptuneAsyncCallback<Void>() {
            @Override
            public void onNeptuneFailure( Throwable caught ) {
            }

            @Override
            public void onNeptuneSuccess( Void result ) {
            }
        } );

    }

    public Table<Long, UiAuditRecord> getAuditTable() {
        return this.table;
    }

    public void clearMessages() {
        this.successPanel.reset();
        this.errorPanel.reset();
    }
    
    public void showBusyIndicator() {
        busyIndicator.center();
    }
    
    public void hideBusyIndicator() {
        busyIndicator.hide();
    }
    
    public void setAuditFilter(UiAudit audit){
    	if(dataProvider != null){
    		dataProvider.setAuditReportFilter(audit);
    	}
    	
    }


}
