package com.ericsson.cms.contractmgmt.client.tab.audit;

import java.util.Date;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.Permissions;
import com.ericsson.cms.contractmgmt.client.customfield.AuditTypeEnum;
import com.ericsson.cms.contractmgmt.client.model.UiAudit;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.model.search.MessageContainer;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class AuditView extends Composite {

    private static final String AUDIT_LISTBOX_WIDTH =  "130px";
    private static final String TEXTBOXWIDGET_WIDTH = "155px";
    private static final String DATE_BOX_WIDTH = "75px";
    private static final int USER_NAME_MAX_LENGH = 50;
    private static final String STYLE_NAME = "content-ContractPanel";

    private final ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create(ContractComponentConstants.class);

    private UiAudit audit;

    // widgets used in this view
    private HeaderPanel header;
    private final VerticalContainer mainContainer;
    private final ContractFormContainer formContainer;
    AuditListPanel auditListPanel;

    // container for error and success messages
    private final MessageContainer messageContainer;

    //filter related
    private ButtonWidget reportButton;
    private TextBoxWidget userName;

    private final LabelWidget startDateLabel = new LabelWidget(constants.auditCreateDate());
    private final LabelWidget endDateLabel = new LabelWidget(constants.auditCreateDateTo());
    private TypedListBoxWidget<Long> contract;
    private final TypedDateBoxWidget startDate = new TypedDateBoxWidget( new DateConverter(
            constants.dateTimeFormat(), constants.dateFormat() ) );

    private final TypedDateBoxWidget endDate = new TypedDateBoxWidget( new DateConverter(
            constants.dateTimeFormat(), constants.dateFormat() ) );;

            private final SuccessPanel successPanel = new SuccessPanel();
            private final ErrorPanel errorPanel = new ErrorPanel();

            private final HorizontalContainer buttonsContainer;
            private final HorizontalContainer dateContainer;
            private final HorizontalContainer endDateLabelContainer;


            public AuditView() {

                mainContainer = new VerticalContainer();
                mainContainer.setStylePrimaryName( STYLE_NAME );
                mainContainer.add( successPanel );
                mainContainer.add( errorPanel );
                buttonsContainer = new HorizontalContainer();
                dateContainer = new HorizontalContainer();
                endDateLabelContainer = new HorizontalContainer();

                formContainer = new ContractFormContainer( HasHorizontalAlignment.ALIGN_LEFT);
                messageContainer = new MessageContainer();

                init();
                initWidget( mainContainer );

            }

            private void init(){
                buildComponents();

                mainContainer.add(header);
                mainContainer.add(formContainer);
                addButtons();
                mainContainer.add(buttonsContainer);

                verifyPermissions();

            }


            private void buildComponents(){

                contract = new TypedListBoxWidget<Long>(new IntegerConverter());
                contract.setWidth(AUDIT_LISTBOX_WIDTH);
                contract.addItem(" ", null);
                for (AuditTypeEnum  auditType : AuditTypeEnum.values() ) {
                    contract.addItem(auditType.toString(), auditType.getValue());
                }

                userName = new TextBoxWidget();
                userName.setWidth(TEXTBOXWIDGET_WIDTH);
                userName.setMaxLength(USER_NAME_MAX_LENGH);
                startDate.setWidth(DATE_BOX_WIDTH);
                startDate.setWidth(DATE_BOX_WIDTH);
                endDate.setWidth(DATE_BOX_WIDTH);
                formContainer.addRow(constants.auditUserName(), userName, false);

                buildDateBoxesContainer();
                formContainer.addRow(startDateLabel, dateContainer, false);
                formContainer.addRow(constants.auditType(), contract, false);
                header = new HeaderPanel(constants.auditReportTitle() );


            }

            private void buildDateBoxesContainer(){

                dateContainer.setWidth(DATE_BOX_WIDTH);
                dateContainer.setCellHorizontalAlignment(this, HasHorizontalAlignment.ALIGN_LEFT);

                endDateLabelContainer.add(endDateLabel);
                endDateLabelContainer.setSpacing(2);

                dateContainer.add(startDate);
                dateContainer.add(endDateLabelContainer);
                dateContainer.add(endDate);

            }

            private void addButtons() {

                reportButton = new ButtonWidget(constants.auditGenerateReport(), new ClickHandler() {

                    @Override
                    public void onClick(ClickEvent event) {

                        if (validate()) {
                            commit();
                            if(auditListPanel != null){
                                auditListPanel.setAuditFilter(audit);


                            }
                            else{
                                auditListPanel = new AuditListPanel(audit);
                                mainContainer.add(auditListPanel);
                            }
                            auditListPanel.getAuditTable().refresh();
                        }
                    }

                });

                reportButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
                reportButton.setEnabled(true);
                buttonsContainer.add(reportButton);

            }

    private boolean validate() {

                Date stDate = startDate.getDatePicker().getValue();
                Date edDate = endDate.getDatePicker().getValue();

                errorPanel.reset();
                boolean valid = formContainer.validate();

                if (stDate != null && edDate != null && !(edDate.after(stDate) || edDate.equals(stDate))) {
                    valid = false;
                    startDate.showValidationError(constants.auditFilterDateValidation());
                }

                if (!valid) {
                    errorPanel.addHeading1(constants.auditValidationMessage());
                }
                return valid;

    }


            private void verifyPermissions(){
                if (ClientAuthorizationManager.isAuthorized(Permissions.CONTRACT_VIEW)) {
                    reportButton.setEnabled(true);
                }

            }

            @Override
            public String getStyleName() {
                return null;
            }

            @Override
            public Widget getWidget() {
                return this;
            }

            @Override
            protected void onUnload() {
                super.onUnload();
                if(auditListPanel != null){
                    resetAuditListPanel();
                }
            }

            public void commit() {
                checkDates();
                audit = new UiAudit();
                audit.setUserName(userName.getText());
                audit.setStartDate(startDate.getDatePicker().getValue());
                audit.setEndDate(endDate.getDatePicker().getValue());
                audit.setAuditType(contract.getSelectedItem());
            }


            public void showErrorMessage(String message) {
                this.messageContainer.addErrorMessage(message, true);
            }

            private void checkDates(){
                if(startDate.getTextValue().trim().isEmpty()){
                    startDate.getDatePicker().setValue(null);
                }
                if(endDate.getTextValue().trim().isEmpty()){
                    endDate.getDatePicker().setValue(null);
                }
            }

            private void reset(){

                if(userName != null){
                    userName.setText("");
                }
                if(contract != null){
                    contract.setSelectedIndex(0);
                }
                if(startDate != null){
                    startDate.setTextValue(null);
                    startDate.clearValidationError();
                }
                if(endDate != null){
                    endDate.setTextValue(null);
                }

            }

            private void resetAuditListPanel(){
                auditListPanel.clearMessages();
                mainContainer.remove(mainContainer.getWidgetIndex(auditListPanel));
                auditListPanel=null;
            }

}

