package com.ericsson.cms.contractmgmt.client.tab.config;

import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;

public class ConfigurationAnchorChangeListener implements AnchorChangeListener {

    // constants in the url e.g. ?copyrightHolderId=1&contractId=1
    private static String FIELD_ID = "fieldId";
    private static String PARAMETER_DELIMITER = "&";
    private static String VALUE_DELIMITER = "=";
    private final UserDefinedFieldListPanel widget;

    public ConfigurationAnchorChangeListener( UserDefinedFieldListPanel listPanel ) {
        this.widget = listPanel;
    }

    @Override
    public void anchorChanged( String anchor ) {

        /* Check for anchor with title list id */
        if ( anchor != null && anchor.contains( FIELD_ID ) ) {
            widget.getUserDefinedFieldsTable().reset();

            // skip the first char
            anchor = anchor.substring( 1 );
            // extract the info from the url
            String[] params = anchor.split( PARAMETER_DELIMITER );
            for ( String p : params ) {
                String[] paramValue = p.split( VALUE_DELIMITER );
                if ( paramValue[0].equalsIgnoreCase( FIELD_ID ) ) {
                    Long.parseLong( paramValue[1] );
                }
            }

        } else {
            widget.getUserDefinedFieldsTable().setAnchor( anchor );
        }
    }
}
