package com.ericsson.cms.contractmgmt.client.tab.config;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldListPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class ConfigurationTab extends Composite implements IConfigTabPanel {

    private final String displayName;
    private VerticalContainer mainContainer;
    private UserDefinedFieldListPanel listPanel;
    private ConfigurableFieldListPanel configurableFieldListPanel;
    private RoundedDisclosureContainer configurableFieldsContainer;
    private RoundedDisclosureContainer userDefinedFieldsContainer;
    
    private static final String STYLE_NAME = "configuration-panel";

    private ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );

    public ConfigurationTab( String screenName, String displayName ) {
        this( screenName, displayName, null, true );
    }

    public ConfigurationTab( String screenName, String displayName,
            ConfigurableFieldListPanel configurableFieldListPanel, boolean showUserDefinedFields ) {
        this.displayName = displayName;
        this.listPanel = new UserDefinedFieldListPanel( screenName );
        this.configurableFieldListPanel = configurableFieldListPanel;
        this.mainContainer = new VerticalContainer();
        LabelWidget label1 = new LabelWidget();
        mainContainer.add( label1 );
        mainContainer.setCellHeight( label1, "10" );

        if ( configurableFieldListPanel != null ) {
            configurableFieldsContainer = new RoundedDisclosureContainer( constants.configurableFields() );
            configurableFieldsContainer.setOpen( true );
            configurableFieldsContainer.add( configurableFieldListPanel );

            this.mainContainer.add( configurableFieldsContainer );
            LabelWidget label2 = new LabelWidget();
            mainContainer.add( label2 );
            mainContainer.setCellHeight( label2, "10" );
        }

        if ( showUserDefinedFields ) {
            userDefinedFieldsContainer = new RoundedDisclosureContainer( constants.userDefinedFields() );
            userDefinedFieldsContainer.setOpen( true );
            userDefinedFieldsContainer.addStyleName(STYLE_NAME);
            userDefinedFieldsContainer.add( listPanel );
            this.mainContainer.add( userDefinedFieldsContainer );
        }

        initWidget( mainContainer );
    }

    public void setSelected( boolean selected ) {
        if ( selected ) {
            if ( this.configurableFieldListPanel != null ) {
                this.configurableFieldListPanel.getTable().refresh();
            }
            this.listPanel.getUserDefinedFieldsTable().refresh();
            this.listPanel.clearMessages();
        }
    }

    public String getDisplayName() {
        return displayName;
    }

}
