package com.ericsson.cms.contractmgmt.client.tab.config;



import java.util.ArrayList;

import java.util.List;



import com.ericsson.cms.contractmgmt.client.ContractComponent;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;

import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldFactory;

import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;

import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;

import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldListPanel;

import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ContractConfigurableFieldDataProvider;

import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.DealConfigurableFieldDataProvider;

import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.DistributionConfigurableFieldDataProvider;

import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.LicenseConfigurableFieldDataProvider;

import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.PricingConfigurableFieldDataProvider;

import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.StorageMetadataConfigurableFieldDataProvider;

import com.google.gwt.core.client.GWT;

import com.google.gwt.event.logical.shared.SelectionEvent;

import com.google.gwt.event.logical.shared.SelectionHandler;

import com.google.gwt.user.client.ui.Composite;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;

import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;

import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;



public class ConfigurationView extends Composite {



    private static final String STYLE_TABCONTAINER = "license-tabContainer";

    private static final String STYLE_NAME = "content-ContractPanel";



    private ContractComponentConstants constants = (ContractComponentConstants) GWT

            .create( ContractComponentConstants.class );



    private TabContainer tabContainer;

    private List<IConfigTabPanel> tabs;

    private VerticalContainer mainContainer;

    private HorizontalContainer buttonsContainer;

    

    private HeaderPanel header;



    private final SuccessPanel successPanel = new SuccessPanel();

    private final ErrorPanel errorPanel = new ErrorPanel();

    

    private ConfigurationViewAnchorChangeListener listener;



    public ConfigurationView() {



        mainContainer = new VerticalContainer();

		mainContainer.setStylePrimaryName(STYLE_NAME);

		header = new HeaderPanel(constants.menuItemConfiguration());

		mainContainer.add(header);

        mainContainer.add( successPanel );

        mainContainer.add( errorPanel );



        initTabs();



        buttonsContainer = new HorizontalContainer();

        buttonsContainer.setSpacing( 5 );

        mainContainer.add( buttonsContainer );

        

        listener = new ConfigurationViewAnchorChangeListener(this);



        initWidget( mainContainer );

    }



    private void initTabs() {



        tabContainer = new TabContainer();

        tabContainer.addSelectionHandler( new SelectionHandler<Integer>() {

            @Override

            public void onSelection( SelectionEvent<Integer> event ) {

                for ( int i = 0; i < tabs.size(); ++i ) {

                    tabs.get( i ).setSelected( i == event.getSelectedItem() );

                }

            }

        } );

        tabContainer.addStyleName( STYLE_TABCONTAINER );



        tabs = new ArrayList<IConfigTabPanel>();

        addTabs();



        mainContainer.add( tabContainer );

    }



    private void addTabs() {

        ConfigurationTab copyrightHolderTab = new ConfigurationTab(

                CustomFieldFactory.COPYRIGHT_HOLDER_SCREEN, constants.copyrightHolderTabDisplayName() );

        tabs.add( copyrightHolderTab );

        tabContainer.add( copyrightHolderTab, copyrightHolderTab.getDisplayName() );



        ConfigurationTab contractTab = new ConfigurationTab( CustomFieldFactory.CONTRACT_SCREEN,

                constants.contractHolderTabDisplayName(), new ConfigurableFieldListPanel(

                        new ContractConfigurableFieldDataProvider() ), true );

        tabs.add( contractTab );

        tabContainer.add( contractTab, contractTab.getDisplayName() );



        ConfigurationTab dealTab = new ConfigurationTab( CustomFieldFactory.DEAL_SCREEN,

                constants.dealTabDisplayName(), new ConfigurableFieldListPanel(

                        new DealConfigurableFieldDataProvider() ), true );

        tabs.add( dealTab );

        tabContainer.add( dealTab, dealTab.getDisplayName() );



        ConfigurationTab licenseTab = new ConfigurationTab( CustomFieldFactory.LICENSE_SCREEN,

                constants.licenseTabDisplayName(), new ConfigurableFieldListPanel(

                        new LicenseConfigurableFieldDataProvider() ), true );

        tabs.add( licenseTab );

        tabContainer.add( licenseTab, licenseTab.getDisplayName() );



        ConfigurationTab distributionMgmtTab = new ConfigurationTab( CustomFieldFactory.DISTRIBUTION_SCREEN,

                constants.distributionTabDisplayName(), new ConfigurableFieldListPanel(

                        new DistributionConfigurableFieldDataProvider() ), true );

        tabs.add( distributionMgmtTab );

        tabContainer.add( distributionMgmtTab, distributionMgmtTab.getDisplayName() );



        ConfigurationTab storageTab = new ConfigurationTab( CustomFieldFactory.STORAGE_METADATA_SCREEN,

                constants.storageTabDisplayName(), new ConfigurableFieldListPanel(

                        new StorageMetadataConfigurableFieldDataProvider() ), true );

        tabs.add( storageTab );

        tabContainer.add( storageTab, storageTab.getDisplayName() );

        

        ConfigurationTab pricingTab = new ConfigurationTab( CustomFieldFactory.PRICING_SCREEN,

                constants.pricingTabDisplayName(), new ConfigurableFieldListPanel(

                        new PricingConfigurableFieldDataProvider() ), false );

        tabs.add( pricingTab );

        tabContainer.add( pricingTab, pricingTab.getDisplayName() );



        ConfigurationTab assetTab = new ConfigurationTab( CustomFieldFactory.ASSET_ENHANCEMENT_SCREEN,

                constants.assetTabDisplayName() );

        tabs.add( assetTab );

        tabContainer.add( assetTab, assetTab.getDisplayName() );



        if (ContractComponent.getInstance().isSchedulerLicensed()) {

			ScheduleTab emailSchedulerTab = new ScheduleTab();

			tabs.add(emailSchedulerTab);

			tabContainer.add(emailSchedulerTab, constants.emailNotificationScheduler());

        }

        

        selectTab(0);

    }



	/**

	 * @param copyrightHolderTab

	 */

	public void selectTab(long tabIndex) {

        tabContainer.selectTab((int) tabIndex);

        if (tabIndex >= 0 && tabIndex < tabs.size()) {

        	tabs.get((int) tabIndex).setSelected( true );

        }

	}



	/**

	 * @return the listener

	 */

	public ConfigurationViewAnchorChangeListener getAnchorChangeListener() {

		return listener;

	}

}

