package com.ericsson.cms.contractmgmt.client.tab.config;

import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;

public class ConfigurationViewAnchorChangeListener implements AnchorChangeListener {

    // constants in the url e.g. ?tab=1
    private static String TAB_INDEX = "tab";
    private static String PARAMETER_DELIMITER = "&";
    private static String VALUE_DELIMITER = "=";
    private final ConfigurationView widget;

    public ConfigurationViewAnchorChangeListener( ConfigurationView widget ) {
        this.widget = widget;
    }

    @Override
    public void anchorChanged( String anchor ) {
        if ( anchor != null && anchor.contains( TAB_INDEX ) ) {
            long tabIndex = 0L;
            // skip the first char
            anchor = anchor.substring( 1 );
            // extract the info from the url
            String[] params = anchor.split( PARAMETER_DELIMITER );
            for ( String p : params ) {
                String[] paramValue = p.split( VALUE_DELIMITER );
                if ( paramValue[0].equalsIgnoreCase( TAB_INDEX ) ) {
                    tabIndex = Long.parseLong( paramValue[1] );
                }
            }
            
            widget.selectTab(tabIndex);
        } 
    }
}
