/**
 * 
 */
package com.ericsson.cms.contractmgmt.client.tab.config;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleType;
import com.ericsson.cms.scheduling.ui.client.widgets.TimeEntryWidget;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Label;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

/**
 * @author amit.r.seth
 *
 */
public class EveryDayRow extends HorizontalContainer {

	private static final int EVERY_DAY = 1;
	
	Label everyLabel;
	private TimeEntryWidget timeEntryWidget;

	private static ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );

	public EveryDayRow() {
		super();
		
		Label everyDay = new Label(constants.everyDayAtLabel());
		this.add(everyDay);
		timeEntryWidget = new TimeEntryWidget();
		this.add(timeEntryWidget);
	}
	
	public ScheduleType getScheduleType() {
		return ScheduleType.EVERY_N_DAYS;
	}

	public ScheduleInfo getScheduleInfo() {
		ScheduleInfo scheduleInfo = new ScheduleInfo();
		
		scheduleInfo.setScheduleType(getScheduleType());
		scheduleInfo.setnDays(EVERY_DAY);
		scheduleInfo.setSpecificTime(timeEntryWidget.getTime());
		
		return scheduleInfo;
	}
	
	public void setScheduleInfo(ScheduleInfo scheduleInfo) {
		if(scheduleInfo == null) {
			return;
		}
		timeEntryWidget.setTime(scheduleInfo.getSpecificTime());
	}

	public void reset() {
		timeEntryWidget.reset();
	}

	public List<String> validate() {
		List<String> validationMessages = new ArrayList<String>();
		
		validationMessages.addAll(timeEntryWidget.validate());
		
		return validationMessages;
	}

	public static String getScheduleInfoString(ScheduleInfo scheduleInfo) {
		String scheduleInfoString = "";
		
		if (scheduleInfo != null) {
			scheduleInfoString = constants.everyDayAtLabel();
			scheduleInfoString += " ";
			scheduleInfoString += scheduleInfo.getSpecificTime();
		}
		
		return scheduleInfoString;
	}
}
