package com.ericsson.cms.contractmgmt.client.tab.config;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.ValueFormatException;

/**
 * Converts a value from percentage to string and vice versa
 * 
 * @author Daniel Paranhos
 */
public class PercentageConverter implements IValueConverter<String> {

    /**
     * Constructor
     */
    public PercentageConverter() {
    }

    @Override
    public String getStringValue( String typedValue ) {
        return typedValue;
    }

    @Override
    public String getTypedValue( String value ) throws ValueFormatException {
        Float result = null;

        try {
            if ( value != null && value.trim().length() > 0 ) {
                result = new Float( value.trim() );
            }
            if ( ( result != null ) && ( ( result < 0 ) || ( result > 100 ) ) ) {
                throw new ValueFormatException( value + " is not a valid percentage value." );
            }
        } catch ( NumberFormatException nfe ) {
            throw new ValueFormatException( value + " is not a valid percentage value." );
        }

        return (result != null) ? result.toString() : null;
    }
}
