package com.ericsson.cms.contractmgmt.client.tab.config;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.ValueFormatException;

/**
 * Converts a value from positive float to string and vice versa
 * 
 * @author Daniel Paranhos
 */
public class PositiveFloatConverter implements IValueConverter<String> {

    /**
     * Constructor
     */
    public PositiveFloatConverter() {
    }

    @Override
    public String getStringValue( String typedValue ) {
        return typedValue;
    }

    @Override
    public String getTypedValue( String value ) throws ValueFormatException {
        Float result = null;

        try {
            if ( value != null && value.trim().length() > 0 ) {
                result = new Float( value.trim() );
            }
            if ( ( result != null ) && ( result < 0 ) ) {
                throw new ValueFormatException( value + " is not a valid positive decimal number." );
            }
        } catch ( NumberFormatException nfe ) {
            throw new ValueFormatException( value + " is not a valid positive decimal number." );
        }

        return (result != null) ? result.toString() : null;
    }
}
