package com.ericsson.cms.contractmgmt.client.tab.config;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.ValueFormatException;

/**
 * Converts a value from positive integer to string and vice versa
 * 
 * @author Daniel Paranhos
 */
public class PositiveIntegerConverter implements IValueConverter<Integer> {

    private Integer maxValue = null;
    /**
     * Constructor
     */
    public PositiveIntegerConverter() {
    }

    /**
     * Constructor
     * If constructor with maxValue is used then besides being positive the Converter must ensure
     * does not exceed the value set in maxValue
     */
    public PositiveIntegerConverter(Integer maxValue) {
        if(maxValue != null && maxValue > 0){
            this.maxValue = maxValue;
        }

    }

    @Override
    public String getStringValue( Integer typedValue ) {
        return typedValue == null ? null : typedValue.toString();
    }

    @Override
    public Integer getTypedValue( String value ) throws ValueFormatException {
        Integer result = null;

        try {
            if ( value != null && value.trim().length() > 0 ) {
                result = Integer.valueOf( value.trim() );
            }
            if ( result != null && result < 0  || result != null && result > Integer.MAX_VALUE) {
                throw new ValueFormatException( value + " is not a valid positive integer." );
            }
        } catch ( NumberFormatException nfe ) {
            throw new ValueFormatException( value + " is not a valid positive integer." );
        }

        if (result != null && maxValue != null && result > maxValue) {
            throw new ValueFormatException(value + " cannot be bigger than " + maxValue
                    + " and it must also be a positive number");
        }

        return result;
    }
}
